/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.PitStudent;
import org.unitime.timetable.model.PitStudentAcadAreaMajorClassification;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;

@MappedSuperclass
public abstract class BasePitStudentAcadAreaMajorClassification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Double iWeight;
    private PitStudent iPitStudent;
    private AcademicArea iAcademicArea;
    private AcademicClassification iAcademicClassification;
    private PosMajor iMajor;
    private PosMajorConcentration iConcentration;

    public BasePitStudentAcadAreaMajorClassification() {
    }

    public BasePitStudentAcadAreaMajorClassification(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="weight", nullable=true)
    public Double getWeight() {
        return this.iWeight;
    }

    public void setWeight(Double weight) {
        this.iWeight = weight;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_student_id", nullable=false)
    public PitStudent getPitStudent() {
        return this.iPitStudent;
    }

    public void setPitStudent(PitStudent pitStudent) {
        this.iPitStudent = pitStudent;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_area_id", nullable=false)
    public AcademicArea getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicArea academicArea) {
        this.iAcademicArea = academicArea;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_clasf_id", nullable=false)
    public AcademicClassification getAcademicClassification() {
        return this.iAcademicClassification;
    }

    public void setAcademicClassification(AcademicClassification academicClassification) {
        this.iAcademicClassification = academicClassification;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="major_id", nullable=false)
    public PosMajor getMajor() {
        return this.iMajor;
    }

    public void setMajor(PosMajor major) {
        this.iMajor = major;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="concentration_id", nullable=true)
    public PosMajorConcentration getConcentration() {
        return this.iConcentration;
    }

    public void setConcentration(PosMajorConcentration concentration) {
        this.iConcentration = concentration;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitStudentAcadAreaMajorClassification)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitStudentAcadAreaMajorClassification)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitStudentAcadAreaMajorClassification)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitStudentAcadAreaMajorClassification[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitStudentAcadAreaMajorClassification[\n\tAcademicArea: " + this.getAcademicArea() + "\n\tAcademicClassification: " + this.getAcademicClassification() + "\n\tConcentration: " + this.getConcentration() + "\n\tMajor: " + this.getMajor() + "\n\tPitStudent: " + this.getPitStudent() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tWeight: " + this.getWeight() + "]";
    }
}

