/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PitStudent;
import org.unitime.timetable.model.PitStudentAcadAreaMajorClassification;
import org.unitime.timetable.model.PitStudentAcadAreaMinorClassification;
import org.unitime.timetable.model.PitStudentClassEnrollment;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.Student;

@MappedSuperclass
public abstract class BasePitStudent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iEmail;
    private PointInTimeData iPointInTimeData;
    private Student iStudent;
    private Set<PitStudentAcadAreaMajorClassification> iPitAcadAreaMajorClassifications;
    private Set<PitStudentAcadAreaMinorClassification> iPitAcadAreaMinorClassifications;
    private Set<PitStudentClassEnrollment> iPitClassEnrollments;

    public BasePitStudent() {
    }

    public BasePitStudent(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="first_name", nullable=false, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="middle_name", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="last_name", nullable=false, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="point_in_time_data_id", nullable=false)
    public PointInTimeData getPointInTimeData() {
        return this.iPointInTimeData;
    }

    public void setPointInTimeData(PointInTimeData pointInTimeData) {
        this.iPointInTimeData = pointInTimeData;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="student_id", nullable=true)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitStudent", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitStudentAcadAreaMajorClassification> getPitAcadAreaMajorClassifications() {
        return this.iPitAcadAreaMajorClassifications;
    }

    public void setPitAcadAreaMajorClassifications(Set<PitStudentAcadAreaMajorClassification> pitAcadAreaMajorClassifications) {
        this.iPitAcadAreaMajorClassifications = pitAcadAreaMajorClassifications;
    }

    public void addToPitAcadAreaMajorClassifications(PitStudentAcadAreaMajorClassification pitStudentAcadAreaMajorClassification) {
        if (this.iPitAcadAreaMajorClassifications == null) {
            this.iPitAcadAreaMajorClassifications = new HashSet<PitStudentAcadAreaMajorClassification>();
        }
        this.iPitAcadAreaMajorClassifications.add(pitStudentAcadAreaMajorClassification);
    }

    @Deprecated
    public void addTopitAcadAreaMajorClassifications(PitStudentAcadAreaMajorClassification pitStudentAcadAreaMajorClassification) {
        this.addToPitAcadAreaMajorClassifications(pitStudentAcadAreaMajorClassification);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitStudent", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitStudentAcadAreaMinorClassification> getPitAcadAreaMinorClassifications() {
        return this.iPitAcadAreaMinorClassifications;
    }

    public void setPitAcadAreaMinorClassifications(Set<PitStudentAcadAreaMinorClassification> pitAcadAreaMinorClassifications) {
        this.iPitAcadAreaMinorClassifications = pitAcadAreaMinorClassifications;
    }

    public void addToPitAcadAreaMinorClassifications(PitStudentAcadAreaMinorClassification pitStudentAcadAreaMinorClassification) {
        if (this.iPitAcadAreaMinorClassifications == null) {
            this.iPitAcadAreaMinorClassifications = new HashSet<PitStudentAcadAreaMinorClassification>();
        }
        this.iPitAcadAreaMinorClassifications.add(pitStudentAcadAreaMinorClassification);
    }

    @Deprecated
    public void addTopitAcadAreaMinorClassifications(PitStudentAcadAreaMinorClassification pitStudentAcadAreaMinorClassification) {
        this.addToPitAcadAreaMinorClassifications(pitStudentAcadAreaMinorClassification);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitStudent", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitStudentClassEnrollment> getPitClassEnrollments() {
        return this.iPitClassEnrollments;
    }

    public void setPitClassEnrollments(Set<PitStudentClassEnrollment> pitClassEnrollments) {
        this.iPitClassEnrollments = pitClassEnrollments;
    }

    public void addToPitClassEnrollments(PitStudentClassEnrollment pitStudentClassEnrollment) {
        if (this.iPitClassEnrollments == null) {
            this.iPitClassEnrollments = new HashSet<PitStudentClassEnrollment>();
        }
        this.iPitClassEnrollments.add(pitStudentClassEnrollment);
    }

    @Deprecated
    public void addTopitClassEnrollments(PitStudentClassEnrollment pitStudentClassEnrollment) {
        this.addToPitClassEnrollments(pitStudentClassEnrollment);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitStudent)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitStudent)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitStudent)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitStudent[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitStudent[\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tPointInTimeData: " + this.getPointInTimeData() + "\n\tStudent: " + this.getStudent() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

