/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.PitInstructionalOffering;
import org.unitime.timetable.model.PitOfferingCoordinator;
import org.unitime.timetable.model.TeachingResponsibility;

@MappedSuperclass
public abstract class BasePitOfferingCoordinator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPercentShare;
    private PitInstructionalOffering iPitInstructionalOffering;
    private PitDepartmentalInstructor iPitDepartmentalInstructor;
    private TeachingResponsibility iResponsibility;

    public BasePitOfferingCoordinator() {
    }

    public BasePitOfferingCoordinator(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="percent_share", nullable=false, length=3)
    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_offering_id", nullable=false)
    public PitInstructionalOffering getPitInstructionalOffering() {
        return this.iPitInstructionalOffering;
    }

    public void setPitInstructionalOffering(PitInstructionalOffering pitInstructionalOffering) {
        this.iPitInstructionalOffering = pitInstructionalOffering;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_dept_instr_id", nullable=false)
    public PitDepartmentalInstructor getPitDepartmentalInstructor() {
        return this.iPitDepartmentalInstructor;
    }

    public void setPitDepartmentalInstructor(PitDepartmentalInstructor pitDepartmentalInstructor) {
        this.iPitDepartmentalInstructor = pitDepartmentalInstructor;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="responsibility_id", nullable=true)
    public TeachingResponsibility getResponsibility() {
        return this.iResponsibility;
    }

    public void setResponsibility(TeachingResponsibility responsibility) {
        this.iResponsibility = responsibility;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitOfferingCoordinator)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitOfferingCoordinator)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitOfferingCoordinator)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitOfferingCoordinator[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitOfferingCoordinator[\n\tPercentShare: " + this.getPercentShare() + "\n\tPitDepartmentalInstructor: " + this.getPitDepartmentalInstructor() + "\n\tPitInstructionalOffering: " + this.getPitInstructionalOffering() + "\n\tResponsibility: " + this.getResponsibility() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

