/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.PitCourseOffering;
import org.unitime.timetable.model.PitInstrOfferingConfig;
import org.unitime.timetable.model.PitInstructionalOffering;
import org.unitime.timetable.model.PitOfferingCoordinator;
import org.unitime.timetable.model.PointInTimeData;

@MappedSuperclass
public abstract class BasePitInstructionalOffering
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iInstrOfferingPermId;
    private Integer iDemand;
    private Integer iLimit;
    private Long iUniqueIdRolledForwardFrom;
    private String iExternalUniqueId;
    private Integer iEnrollment;
    private PointInTimeData iPointInTimeData;
    private InstructionalOffering iInstructionalOffering;
    private Set<PitCourseOffering> iPitCourseOfferings;
    private Set<PitInstrOfferingConfig> iPitInstrOfferingConfigs;
    private Set<PitOfferingCoordinator> iPitOfferingCoordinators;

    public BasePitInstructionalOffering() {
    }

    public BasePitInstructionalOffering(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="instr_offering_perm_id", nullable=false, length=10)
    public Integer getInstrOfferingPermId() {
        return this.iInstrOfferingPermId;
    }

    public void setInstrOfferingPermId(Integer instrOfferingPermId) {
        this.iInstrOfferingPermId = instrOfferingPermId;
    }

    @Column(name="demand", nullable=true, length=4)
    public Integer getDemand() {
        return this.iDemand;
    }

    public void setDemand(Integer demand) {
        this.iDemand = demand;
    }

    @Column(name="offr_limit", nullable=true, length=10)
    public Integer getLimit() {
        return this.iLimit;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Formula(value="(select count(distinct e.pit_student_id) from %SCHEMA%.pit_student_class_enrl e inner join %SCHEMA%.pit_course_offering co on co.uniqueid = e.pit_course_offering_id where co.pit_instr_offr_id = uniqueid)")
    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="point_in_time_data_id", nullable=false)
    public PointInTimeData getPointInTimeData() {
        return this.iPointInTimeData;
    }

    public void setPointInTimeData(PointInTimeData pointInTimeData) {
        this.iPointInTimeData = pointInTimeData;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="instr_offering_id", nullable=true)
    public InstructionalOffering getInstructionalOffering() {
        return this.iInstructionalOffering;
    }

    public void setInstructionalOffering(InstructionalOffering instructionalOffering) {
        this.iInstructionalOffering = instructionalOffering;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitInstructionalOffering", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitCourseOffering> getPitCourseOfferings() {
        return this.iPitCourseOfferings;
    }

    public void setPitCourseOfferings(Set<PitCourseOffering> pitCourseOfferings) {
        this.iPitCourseOfferings = pitCourseOfferings;
    }

    public void addToPitCourseOfferings(PitCourseOffering pitCourseOffering) {
        if (this.iPitCourseOfferings == null) {
            this.iPitCourseOfferings = new HashSet<PitCourseOffering>();
        }
        this.iPitCourseOfferings.add(pitCourseOffering);
    }

    @Deprecated
    public void addTopitCourseOfferings(PitCourseOffering pitCourseOffering) {
        this.addToPitCourseOfferings(pitCourseOffering);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitInstructionalOffering", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitInstrOfferingConfig> getPitInstrOfferingConfigs() {
        return this.iPitInstrOfferingConfigs;
    }

    public void setPitInstrOfferingConfigs(Set<PitInstrOfferingConfig> pitInstrOfferingConfigs) {
        this.iPitInstrOfferingConfigs = pitInstrOfferingConfigs;
    }

    public void addToPitInstrOfferingConfigs(PitInstrOfferingConfig pitInstrOfferingConfig) {
        if (this.iPitInstrOfferingConfigs == null) {
            this.iPitInstrOfferingConfigs = new HashSet<PitInstrOfferingConfig>();
        }
        this.iPitInstrOfferingConfigs.add(pitInstrOfferingConfig);
    }

    @Deprecated
    public void addTopitInstrOfferingConfigs(PitInstrOfferingConfig pitInstrOfferingConfig) {
        this.addToPitInstrOfferingConfigs(pitInstrOfferingConfig);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitInstructionalOffering")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitOfferingCoordinator> getPitOfferingCoordinators() {
        return this.iPitOfferingCoordinators;
    }

    public void setPitOfferingCoordinators(Set<PitOfferingCoordinator> pitOfferingCoordinators) {
        this.iPitOfferingCoordinators = pitOfferingCoordinators;
    }

    public void addToPitOfferingCoordinators(PitOfferingCoordinator pitOfferingCoordinator) {
        if (this.iPitOfferingCoordinators == null) {
            this.iPitOfferingCoordinators = new HashSet<PitOfferingCoordinator>();
        }
        this.iPitOfferingCoordinators.add(pitOfferingCoordinator);
    }

    @Deprecated
    public void addTopitOfferingCoordinators(PitOfferingCoordinator pitOfferingCoordinator) {
        this.addToPitOfferingCoordinators(pitOfferingCoordinator);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitInstructionalOffering)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitInstructionalOffering)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitInstructionalOffering)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitInstructionalOffering[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitInstructionalOffering[\n\tDemand: " + this.getDemand() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tInstrOfferingPermId: " + this.getInstrOfferingPermId() + "\n\tInstructionalOffering: " + this.getInstructionalOffering() + "\n\tLimit: " + this.getLimit() + "\n\tPointInTimeData: " + this.getPointInTimeData() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

