/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.PositionType;

@MappedSuperclass
public abstract class BasePitDepartmentalInstructor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iCareerAcct;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iEmail;
    private PositionType iPositionType;
    private Department iDepartment;
    private PointInTimeData iPointInTimeData;
    private DepartmentalInstructor iDepartmentalInstructor;
    private Set<PitClassInstructor> iPitClassesInstructing;

    public BasePitDepartmentalInstructor() {
    }

    public BasePitDepartmentalInstructor(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="career_acct", nullable=true, length=20)
    public String getCareerAcct() {
        return this.iCareerAcct;
    }

    public void setCareerAcct(String careerAcct) {
        this.iCareerAcct = careerAcct;
    }

    @Column(name="fname", nullable=true, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="mname", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="lname", nullable=false, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="pos_code_type", nullable=true)
    public PositionType getPositionType() {
        return this.iPositionType;
    }

    public void setPositionType(PositionType positionType) {
        this.iPositionType = positionType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="department_id", nullable=false)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="point_in_time_data_id", nullable=false)
    public PointInTimeData getPointInTimeData() {
        return this.iPointInTimeData;
    }

    public void setPointInTimeData(PointInTimeData pointInTimeData) {
        this.iPointInTimeData = pointInTimeData;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="dept_instructor_id", nullable=true)
    public DepartmentalInstructor getDepartmentalInstructor() {
        return this.iDepartmentalInstructor;
    }

    public void setDepartmentalInstructor(DepartmentalInstructor departmentalInstructor) {
        this.iDepartmentalInstructor = departmentalInstructor;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitDepartmentalInstructor", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClassInstructor> getPitClassesInstructing() {
        return this.iPitClassesInstructing;
    }

    public void setPitClassesInstructing(Set<PitClassInstructor> pitClassesInstructing) {
        this.iPitClassesInstructing = pitClassesInstructing;
    }

    public void addToPitClassesInstructing(PitClassInstructor pitClassInstructor) {
        if (this.iPitClassesInstructing == null) {
            this.iPitClassesInstructing = new HashSet<PitClassInstructor>();
        }
        this.iPitClassesInstructing.add(pitClassInstructor);
    }

    @Deprecated
    public void addTopitClassesInstructing(PitClassInstructor pitClassInstructor) {
        this.addToPitClassesInstructing(pitClassInstructor);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitDepartmentalInstructor)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitDepartmentalInstructor)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitDepartmentalInstructor)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitDepartmentalInstructor[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitDepartmentalInstructor[\n\tCareerAcct: " + this.getCareerAcct() + "\n\tDepartment: " + this.getDepartment() + "\n\tDepartmentalInstructor: " + this.getDepartmentalInstructor() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tPointInTimeData: " + this.getPointInTimeData() + "\n\tPositionType: " + this.getPositionType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

