/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PitClassEvent;
import org.unitime.timetable.model.PitClassMeeting;
import org.unitime.timetable.model.PitClassMeetingUtilPeriod;

@MappedSuperclass
public abstract class BasePitClassMeeting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iMeetingDate;
    private Integer iStartPeriod;
    private Integer iStartOffset;
    private Integer iStopPeriod;
    private Integer iStopOffset;
    private Long iLocationPermanentId;
    private Integer iTimePatternMinPerMtg;
    private Integer iCalculatedMinPerMtg;
    private PitClassEvent iPitClassEvent;
    private Set<PitClassMeetingUtilPeriod> iPitClassMeetingUtilPeriods;

    public BasePitClassMeeting() {
    }

    public BasePitClassMeeting(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="meeting_date", nullable=false)
    public Date getMeetingDate() {
        return this.iMeetingDate;
    }

    public void setMeetingDate(Date meetingDate) {
        this.iMeetingDate = meetingDate;
    }

    @Column(name="start_period", nullable=false, length=10)
    public Integer getStartPeriod() {
        return this.iStartPeriod;
    }

    public void setStartPeriod(Integer startPeriod) {
        this.iStartPeriod = startPeriod;
    }

    @Column(name="start_offset", nullable=true, length=10)
    public Integer getStartOffset() {
        return this.iStartOffset;
    }

    public void setStartOffset(Integer startOffset) {
        this.iStartOffset = startOffset;
    }

    @Column(name="stop_period", nullable=false, length=10)
    public Integer getStopPeriod() {
        return this.iStopPeriod;
    }

    public void setStopPeriod(Integer stopPeriod) {
        this.iStopPeriod = stopPeriod;
    }

    @Column(name="stop_offset", nullable=true, length=10)
    public Integer getStopOffset() {
        return this.iStopOffset;
    }

    public void setStopOffset(Integer stopOffset) {
        this.iStopOffset = stopOffset;
    }

    @Column(name="location_perm_id", nullable=true, length=20)
    public Long getLocationPermanentId() {
        return this.iLocationPermanentId;
    }

    public void setLocationPermanentId(Long locationPermanentId) {
        this.iLocationPermanentId = locationPermanentId;
    }

    @Column(name="time_pattern_min_per_mtg", nullable=false, length=10)
    public Integer getTimePatternMinPerMtg() {
        return this.iTimePatternMinPerMtg;
    }

    public void setTimePatternMinPerMtg(Integer timePatternMinPerMtg) {
        this.iTimePatternMinPerMtg = timePatternMinPerMtg;
    }

    @Column(name="calculated_min_per_mtg", nullable=false, length=10)
    public Integer getCalculatedMinPerMtg() {
        return this.iCalculatedMinPerMtg;
    }

    public void setCalculatedMinPerMtg(Integer calculatedMinPerMtg) {
        this.iCalculatedMinPerMtg = calculatedMinPerMtg;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_class_event_id", nullable=false)
    public PitClassEvent getPitClassEvent() {
        return this.iPitClassEvent;
    }

    public void setPitClassEvent(PitClassEvent pitClassEvent) {
        this.iPitClassEvent = pitClassEvent;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitClassMeeting", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClassMeetingUtilPeriod> getPitClassMeetingUtilPeriods() {
        return this.iPitClassMeetingUtilPeriods;
    }

    public void setPitClassMeetingUtilPeriods(Set<PitClassMeetingUtilPeriod> pitClassMeetingUtilPeriods) {
        this.iPitClassMeetingUtilPeriods = pitClassMeetingUtilPeriods;
    }

    public void addToPitClassMeetingUtilPeriods(PitClassMeetingUtilPeriod pitClassMeetingUtilPeriod) {
        if (this.iPitClassMeetingUtilPeriods == null) {
            this.iPitClassMeetingUtilPeriods = new HashSet<PitClassMeetingUtilPeriod>();
        }
        this.iPitClassMeetingUtilPeriods.add(pitClassMeetingUtilPeriod);
    }

    @Deprecated
    public void addTopitClassMeetingUtilPeriods(PitClassMeetingUtilPeriod pitClassMeetingUtilPeriod) {
        this.addToPitClassMeetingUtilPeriods(pitClassMeetingUtilPeriod);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitClassMeeting)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitClassMeeting)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitClassMeeting)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitClassMeeting[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitClassMeeting[\n\tCalculatedMinPerMtg: " + this.getCalculatedMinPerMtg() + "\n\tLocationPermanentId: " + this.getLocationPermanentId() + "\n\tMeetingDate: " + this.getMeetingDate() + "\n\tPitClassEvent: " + this.getPitClassEvent() + "\n\tStartOffset: " + this.getStartOffset() + "\n\tStartPeriod: " + this.getStartPeriod() + "\n\tStopOffset: " + this.getStopOffset() + "\n\tStopPeriod: " + this.getStopPeriod() + "\n\tTimePatternMinPerMtg: " + this.getTimePatternMinPerMtg() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

