/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassEvent;
import org.unitime.timetable.model.PitClassMeeting;

@MappedSuperclass
public abstract class BasePitClassEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iEventName;
    private PitClass iPitClass;
    private Set<PitClassMeeting> iPitClassMeetings;

    public BasePitClassEvent() {
    }

    public BasePitClassEvent(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="event_name", nullable=true, length=100)
    public String getEventName() {
        return this.iEventName;
    }

    public void setEventName(String eventName) {
        this.iEventName = eventName;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_class_id", nullable=false)
    public PitClass getPitClass() {
        return this.iPitClass;
    }

    public void setPitClass(PitClass pitClass) {
        this.iPitClass = pitClass;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitClassEvent", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClassMeeting> getPitClassMeetings() {
        return this.iPitClassMeetings;
    }

    public void setPitClassMeetings(Set<PitClassMeeting> pitClassMeetings) {
        this.iPitClassMeetings = pitClassMeetings;
    }

    public void addToPitClassMeetings(PitClassMeeting pitClassMeeting) {
        if (this.iPitClassMeetings == null) {
            this.iPitClassMeetings = new HashSet<PitClassMeeting>();
        }
        this.iPitClassMeetings.add(pitClassMeeting);
    }

    @Deprecated
    public void addTopitClassMeetings(PitClassMeeting pitClassMeeting) {
        this.addToPitClassMeetings(pitClassMeeting);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitClassEvent)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitClassEvent)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitClassEvent)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitClassEvent[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitClassEvent[\n\tEventName: " + this.getEventName() + "\n\tPitClass: " + this.getPitClass() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

