/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.OnlineSectioningLog;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseOnlineSectioningLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimeStamp;
    private String iStudent;
    private String iOperation;
    private byte[] iAction;
    private Integer iResult;
    private String iUser;
    private Long iCpuTime;
    private Long iWallTime;
    private String iMessage;
    private Long iApiGetTime;
    private Long iApiPostTime;
    private String iApiException;
    private Session iSession;

    public BaseOnlineSectioningLog() {
    }

    public BaseOnlineSectioningLog(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="student", nullable=false, length=40)
    public String getStudent() {
        return this.iStudent;
    }

    public void setStudent(String student) {
        this.iStudent = student;
    }

    @Column(name="operation", nullable=false, length=20)
    public String getOperation() {
        return this.iOperation;
    }

    public void setOperation(String operation) {
        this.iOperation = operation;
    }

    @Column(name="action", nullable=false)
    public byte[] getAction() {
        return this.iAction;
    }

    public void setAction(byte[] action) {
        this.iAction = action;
    }

    @Column(name="result", nullable=true)
    public Integer getResult() {
        return this.iResult;
    }

    public void setResult(Integer result) {
        this.iResult = result;
    }

    @Column(name="user_id", nullable=true, length=40)
    public String getUser() {
        return this.iUser;
    }

    public void setUser(String user) {
        this.iUser = user;
    }

    @Column(name="cpu_time", nullable=true)
    public Long getCpuTime() {
        return this.iCpuTime;
    }

    public void setCpuTime(Long cpuTime) {
        this.iCpuTime = cpuTime;
    }

    @Column(name="wall_time", nullable=true)
    public Long getWallTime() {
        return this.iWallTime;
    }

    public void setWallTime(Long wallTime) {
        this.iWallTime = wallTime;
    }

    @Column(name="message", nullable=true, length=255)
    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    @Column(name="api_get_time", nullable=true)
    public Long getApiGetTime() {
        return this.iApiGetTime;
    }

    public void setApiGetTime(Long apiGetTime) {
        this.iApiGetTime = apiGetTime;
    }

    @Column(name="api_post_time", nullable=true)
    public Long getApiPostTime() {
        return this.iApiPostTime;
    }

    public void setApiPostTime(Long apiPostTime) {
        this.iApiPostTime = apiPostTime;
    }

    @Column(name="api_exception", nullable=true, length=255)
    public String getApiException() {
        return this.iApiException;
    }

    public void setApiException(String apiException) {
        this.iApiException = apiException;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OnlineSectioningLog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((OnlineSectioningLog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((OnlineSectioningLog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "OnlineSectioningLog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "OnlineSectioningLog[\n\tAction: " + this.getAction() + "\n\tApiException: " + this.getApiException() + "\n\tApiGetTime: " + this.getApiGetTime() + "\n\tApiPostTime: " + this.getApiPostTime() + "\n\tCpuTime: " + this.getCpuTime() + "\n\tMessage: " + this.getMessage() + "\n\tOperation: " + this.getOperation() + "\n\tResult: " + this.getResult() + "\n\tSession: " + this.getSession() + "\n\tStudent: " + this.getStudent() + "\n\tTimeStamp: " + this.getTimeStamp() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUser: " + this.getUser() + "\n\tWallTime: " + this.getWallTime() + "]";
    }
}

