/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TeachingResponsibility;

@MappedSuperclass
public abstract class BaseOfferingCoordinator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPercentShare;
    private DepartmentalInstructor iInstructor;
    private InstructionalOffering iOffering;
    private TeachingResponsibility iResponsibility;
    private TeachingRequest iTeachingRequest;

    public BaseOfferingCoordinator() {
    }

    public BaseOfferingCoordinator(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="percent_share", nullable=false, length=3)
    public Integer getPercentShare() {
        return this.iPercentShare;
    }

    public void setPercentShare(Integer percentShare) {
        this.iPercentShare = percentShare;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="instructor_id", nullable=false)
    public DepartmentalInstructor getInstructor() {
        return this.iInstructor;
    }

    public void setInstructor(DepartmentalInstructor instructor) {
        this.iInstructor = instructor;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="offering_id", nullable=false)
    public InstructionalOffering getOffering() {
        return this.iOffering;
    }

    public void setOffering(InstructionalOffering offering) {
        this.iOffering = offering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="responsibility_id", nullable=true)
    public TeachingResponsibility getResponsibility() {
        return this.iResponsibility;
    }

    public void setResponsibility(TeachingResponsibility responsibility) {
        this.iResponsibility = responsibility;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="request_id", nullable=true)
    public TeachingRequest getTeachingRequest() {
        return this.iTeachingRequest;
    }

    public void setTeachingRequest(TeachingRequest teachingRequest) {
        this.iTeachingRequest = teachingRequest;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof OfferingCoordinator)) {
            return false;
        }
        if (this.getUniqueId() == null || ((OfferingCoordinator)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((OfferingCoordinator)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "OfferingCoordinator[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "OfferingCoordinator[\n\tInstructor: " + this.getInstructor() + "\n\tOffering: " + this.getOffering() + "\n\tPercentShare: " + this.getPercentShare() + "\n\tResponsibility: " + this.getResponsibility() + "\n\tTeachingRequest: " + this.getTeachingRequest() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

