/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.Meeting;

@MappedSuperclass
public abstract class BaseMeeting
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iMeetingDate;
    private Integer iStartPeriod;
    private Integer iStartOffset;
    private Integer iStopPeriod;
    private Integer iStopOffset;
    private Long iLocationPermanentId;
    private Boolean iClassCanOverride;
    private Integer iApprovalStatus;
    private Date iApprovalDate;
    private Event iEvent;
    private Set<EventContact> iMeetingContacts;

    public BaseMeeting() {
    }

    public BaseMeeting(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="meeting_date", nullable=false)
    public Date getMeetingDate() {
        return this.iMeetingDate;
    }

    public void setMeetingDate(Date meetingDate) {
        this.iMeetingDate = meetingDate;
    }

    @Column(name="start_period", nullable=false, length=10)
    public Integer getStartPeriod() {
        return this.iStartPeriod;
    }

    public void setStartPeriod(Integer startPeriod) {
        this.iStartPeriod = startPeriod;
    }

    @Column(name="start_offset", nullable=true, length=10)
    public Integer getStartOffset() {
        return this.iStartOffset;
    }

    public void setStartOffset(Integer startOffset) {
        this.iStartOffset = startOffset;
    }

    @Column(name="stop_period", nullable=false, length=10)
    public Integer getStopPeriod() {
        return this.iStopPeriod;
    }

    public void setStopPeriod(Integer stopPeriod) {
        this.iStopPeriod = stopPeriod;
    }

    @Column(name="stop_offset", nullable=true, length=10)
    public Integer getStopOffset() {
        return this.iStopOffset;
    }

    public void setStopOffset(Integer stopOffset) {
        this.iStopOffset = stopOffset;
    }

    @Column(name="location_perm_id", nullable=true, length=20)
    public Long getLocationPermanentId() {
        return this.iLocationPermanentId;
    }

    public void setLocationPermanentId(Long locationPermanentId) {
        this.iLocationPermanentId = locationPermanentId;
    }

    @Column(name="class_can_override", nullable=false)
    public Boolean isClassCanOverride() {
        return this.iClassCanOverride;
    }

    @Transient
    public Boolean getClassCanOverride() {
        return this.iClassCanOverride;
    }

    public void setClassCanOverride(Boolean classCanOverride) {
        this.iClassCanOverride = classCanOverride;
    }

    @Column(name="approval_status", nullable=false)
    public Integer getApprovalStatus() {
        return this.iApprovalStatus;
    }

    public void setApprovalStatus(Integer approvalStatus) {
        this.iApprovalStatus = approvalStatus;
    }

    @Column(name="approval_date", nullable=true)
    public Date getApprovalDate() {
        return this.iApprovalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.iApprovalDate = approvalDate;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="event_id", nullable=false)
    public Event getEvent() {
        return this.iEvent;
    }

    public void setEvent(Event event) {
        this.iEvent = event;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="meeting_contact", joinColumns={@JoinColumn(name="meeting_id")}, inverseJoinColumns={@JoinColumn(name="contact_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<EventContact> getMeetingContacts() {
        return this.iMeetingContacts;
    }

    public void setMeetingContacts(Set<EventContact> meetingContacts) {
        this.iMeetingContacts = meetingContacts;
    }

    public void addToMeetingContacts(EventContact eventContact) {
        if (this.iMeetingContacts == null) {
            this.iMeetingContacts = new HashSet<EventContact>();
        }
        this.iMeetingContacts.add(eventContact);
    }

    @Deprecated
    public void addTomeetingContacts(EventContact eventContact) {
        this.addToMeetingContacts(eventContact);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Meeting)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Meeting)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Meeting)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Meeting[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Meeting[\n\tApprovalDate: " + this.getApprovalDate() + "\n\tApprovalStatus: " + this.getApprovalStatus() + "\n\tClassCanOverride: " + this.getClassCanOverride() + "\n\tEvent: " + this.getEvent() + "\n\tLocationPermanentId: " + this.getLocationPermanentId() + "\n\tMeetingDate: " + this.getMeetingDate() + "\n\tStartOffset: " + this.getStartOffset() + "\n\tStartPeriod: " + this.getStartPeriod() + "\n\tStopOffset: " + this.getStopOffset() + "\n\tStopPeriod: " + this.getStopPeriod() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

