/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BaseManagerRole
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Boolean iPrimary;
    private Boolean iReceiveEmails;
    private Roles iRole;
    private TimetableManager iTimetableManager;

    public BaseManagerRole() {
    }

    public BaseManagerRole(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="tmtbl_mgr_to_roles_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="is_primary", nullable=true)
    public Boolean isPrimary() {
        return this.iPrimary;
    }

    @Transient
    public Boolean getPrimary() {
        return this.iPrimary;
    }

    public void setPrimary(Boolean primary) {
        this.iPrimary = primary;
    }

    @Column(name="receive_emails", nullable=true)
    public Boolean isReceiveEmails() {
        return this.iReceiveEmails;
    }

    @Transient
    public Boolean getReceiveEmails() {
        return this.iReceiveEmails;
    }

    public void setReceiveEmails(Boolean receiveEmails) {
        this.iReceiveEmails = receiveEmails;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="role_id", nullable=false)
    public Roles getRole() {
        return this.iRole;
    }

    public void setRole(Roles role) {
        this.iRole = role;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="manager_id", nullable=false)
    public TimetableManager getTimetableManager() {
        return this.iTimetableManager;
    }

    public void setTimetableManager(TimetableManager timetableManager) {
        this.iTimetableManager = timetableManager;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ManagerRole)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ManagerRole)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ManagerRole)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ManagerRole[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ManagerRole[\n\tPrimary: " + this.getPrimary() + "\n\tReceiveEmails: " + this.getReceiveEmails() + "\n\tRole: " + this.getRole() + "\n\tTimetableManager: " + this.getTimetableManager() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

