/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ExamLocationPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Long iPermanentId;
    private Integer iCapacity;
    private Double iCoordinateX;
    private Double iCoordinateY;
    private Boolean iIgnoreTooFar;
    private Boolean iIgnoreRoomCheck;
    private Double iArea;
    private Integer iEventStatus;
    private String iNote;
    private Integer iBreakTime;
    private String iManagerIds;
    private String iPattern;
    private String iShareNote;
    private String iEventAvailability;
    private Integer iExamCapacity;
    private String iDisplayName;
    private String iExternalUniqueId;
    private String iEventEmail;
    private Session iSession;
    private Department iEventDepartment;
    private RoomType iRoomType;
    private Set<RoomFeature> iFeatures;
    private Set<ExamType> iExamTypes;
    private Set<ExamLocationPref> iExamPreferences;
    private Set<Assignment> iAssignments;
    private Set<RoomGroup> iRoomGroups;
    private Set<RoomDept> iRoomDepts;

    public BaseLocation() {
    }

    public BaseLocation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="room_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="permanent_id", nullable=false, length=20)
    public Long getPermanentId() {
        return this.iPermanentId;
    }

    public void setPermanentId(Long permanentId) {
        this.iPermanentId = permanentId;
    }

    @Column(name="capacity", nullable=false, length=6)
    public Integer getCapacity() {
        return this.iCapacity;
    }

    public void setCapacity(Integer capacity) {
        this.iCapacity = capacity;
    }

    @Column(name="coordinate_x", nullable=true)
    public Double getCoordinateX() {
        return this.iCoordinateX;
    }

    public void setCoordinateX(Double coordinateX) {
        this.iCoordinateX = coordinateX;
    }

    @Column(name="coordinate_y", nullable=true)
    public Double getCoordinateY() {
        return this.iCoordinateY;
    }

    public void setCoordinateY(Double coordinateY) {
        this.iCoordinateY = coordinateY;
    }

    @Column(name="ignore_too_far", nullable=false)
    public Boolean isIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    @Transient
    public Boolean getIgnoreTooFar() {
        return this.iIgnoreTooFar;
    }

    public void setIgnoreTooFar(Boolean ignoreTooFar) {
        this.iIgnoreTooFar = ignoreTooFar;
    }

    @Column(name="ignore_room_check", nullable=false)
    public Boolean isIgnoreRoomCheck() {
        return this.iIgnoreRoomCheck;
    }

    @Transient
    public Boolean getIgnoreRoomCheck() {
        return this.iIgnoreRoomCheck;
    }

    public void setIgnoreRoomCheck(Boolean ignoreRoomCheck) {
        this.iIgnoreRoomCheck = ignoreRoomCheck;
    }

    @Column(name="area", nullable=true)
    public Double getArea() {
        return this.iArea;
    }

    public void setArea(Double area) {
        this.iArea = area;
    }

    @Column(name="event_status", nullable=true)
    public Integer getEventStatus() {
        return this.iEventStatus;
    }

    public void setEventStatus(Integer eventStatus) {
        this.iEventStatus = eventStatus;
    }

    @Column(name="note", nullable=true, length=2048)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="break_time", nullable=true)
    public Integer getBreakTime() {
        return this.iBreakTime;
    }

    public void setBreakTime(Integer breakTime) {
        this.iBreakTime = breakTime;
    }

    @Column(name="manager_ids", nullable=true, length=3000)
    public String getManagerIds() {
        return this.iManagerIds;
    }

    public void setManagerIds(String managerIds) {
        this.iManagerIds = managerIds;
    }

    @Column(name="pattern", nullable=true, length=2016)
    public String getPattern() {
        return this.iPattern;
    }

    public void setPattern(String pattern) {
        this.iPattern = pattern;
    }

    @Column(name="share_note", nullable=true, length=2048)
    public String getShareNote() {
        return this.iShareNote;
    }

    public void setShareNote(String shareNote) {
        this.iShareNote = shareNote;
    }

    @Column(name="availability", nullable=true, length=2016)
    public String getEventAvailability() {
        return this.iEventAvailability;
    }

    public void setEventAvailability(String eventAvailability) {
        this.iEventAvailability = eventAvailability;
    }

    @Column(name="exam_capacity", nullable=true, length=10)
    public Integer getExamCapacity() {
        return this.iExamCapacity;
    }

    public void setExamCapacity(Integer examCapacity) {
        this.iExamCapacity = examCapacity;
    }

    @Column(name="display_name", nullable=true, length=100)
    public String getDisplayName() {
        return this.iDisplayName;
    }

    public void setDisplayName(String displayName) {
        this.iDisplayName = displayName;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEventEmail() {
        return this.iEventEmail;
    }

    public void setEventEmail(String eventEmail) {
        this.iEventEmail = eventEmail;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="event_dept_id", nullable=true)
    public Department getEventDepartment() {
        return this.iEventDepartment;
    }

    public void setEventDepartment(Department eventDepartment) {
        this.iEventDepartment = eventDepartment;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="room_type", nullable=false)
    public RoomType getRoomType() {
        return this.iRoomType;
    }

    public void setRoomType(RoomType roomType) {
        this.iRoomType = roomType;
    }

    @ManyToMany
    @JoinTable(name="room_join_room_feature", joinColumns={@JoinColumn(name="room_id")}, inverseJoinColumns={@JoinColumn(name="feature_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<RoomFeature> getFeatures() {
        return this.iFeatures;
    }

    public void setFeatures(Set<RoomFeature> features) {
        this.iFeatures = features;
    }

    public void addToFeatures(RoomFeature roomFeature) {
        if (this.iFeatures == null) {
            this.iFeatures = new HashSet<RoomFeature>();
        }
        this.iFeatures.add(roomFeature);
    }

    @Deprecated
    public void addTofeatures(RoomFeature roomFeature) {
        this.addToFeatures(roomFeature);
    }

    @ManyToMany
    @JoinTable(name="room_exam_type", joinColumns={@JoinColumn(name="location_id")}, inverseJoinColumns={@JoinColumn(name="exam_type_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExamType> getExamTypes() {
        return this.iExamTypes;
    }

    public void setExamTypes(Set<ExamType> examTypes) {
        this.iExamTypes = examTypes;
    }

    public void addToExamTypes(ExamType examType) {
        if (this.iExamTypes == null) {
            this.iExamTypes = new HashSet<ExamType>();
        }
        this.iExamTypes.add(examType);
    }

    @Deprecated
    public void addToexamTypes(ExamType examType) {
        this.addToExamTypes(examType);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="location", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ExamLocationPref> getExamPreferences() {
        return this.iExamPreferences;
    }

    public void setExamPreferences(Set<ExamLocationPref> examPreferences) {
        this.iExamPreferences = examPreferences;
    }

    public void addToExamPreferences(ExamLocationPref examLocationPref) {
        if (this.iExamPreferences == null) {
            this.iExamPreferences = new HashSet<ExamLocationPref>();
        }
        this.iExamPreferences.add(examLocationPref);
    }

    @Deprecated
    public void addToexamPreferences(ExamLocationPref examLocationPref) {
        this.addToExamPreferences(examLocationPref);
    }

    @ManyToMany(mappedBy="rooms")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToAssignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    @Deprecated
    public void addToassignments(Assignment assignment) {
        this.addToAssignments(assignment);
    }

    @ManyToMany
    @JoinTable(name="room_group_room", joinColumns={@JoinColumn(name="room_id")}, inverseJoinColumns={@JoinColumn(name="room_group_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<RoomGroup> getRoomGroups() {
        return this.iRoomGroups;
    }

    public void setRoomGroups(Set<RoomGroup> roomGroups) {
        this.iRoomGroups = roomGroups;
    }

    public void addToRoomGroups(RoomGroup roomGroup) {
        if (this.iRoomGroups == null) {
            this.iRoomGroups = new HashSet<RoomGroup>();
        }
        this.iRoomGroups.add(roomGroup);
    }

    @Deprecated
    public void addToroomGroups(RoomGroup roomGroup) {
        this.addToRoomGroups(roomGroup);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="room", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<RoomDept> getRoomDepts() {
        return this.iRoomDepts;
    }

    public void setRoomDepts(Set<RoomDept> roomDepts) {
        this.iRoomDepts = roomDepts;
    }

    public void addToRoomDepts(RoomDept roomDept) {
        if (this.iRoomDepts == null) {
            this.iRoomDepts = new HashSet<RoomDept>();
        }
        this.iRoomDepts.add(roomDept);
    }

    @Deprecated
    public void addToroomDepts(RoomDept roomDept) {
        this.addToRoomDepts(roomDept);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Location)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Location)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Location)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Location[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Location[\n\tArea: " + this.getArea() + "\n\tBreakTime: " + this.getBreakTime() + "\n\tCapacity: " + this.getCapacity() + "\n\tCoordinateX: " + this.getCoordinateX() + "\n\tCoordinateY: " + this.getCoordinateY() + "\n\tDisplayName: " + this.getDisplayName() + "\n\tEventAvailability: " + this.getEventAvailability() + "\n\tEventDepartment: " + this.getEventDepartment() + "\n\tEventEmail: " + this.getEventEmail() + "\n\tEventStatus: " + this.getEventStatus() + "\n\tExamCapacity: " + this.getExamCapacity() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tIgnoreRoomCheck: " + this.getIgnoreRoomCheck() + "\n\tIgnoreTooFar: " + this.getIgnoreTooFar() + "\n\tManagerIds: " + this.getManagerIds() + "\n\tNote: " + this.getNote() + "\n\tPattern: " + this.getPattern() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tRoomType: " + this.getRoomType() + "\n\tSession: " + this.getSession() + "\n\tShareNote: " + this.getShareNote() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

