/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.LastLikeCourseDemand;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;

@MappedSuperclass
public abstract class BaseLastLikeCourseDemand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iCourseNbr;
    private Integer iPriority;
    private String iCoursePermId;
    private Student iStudent;
    private SubjectArea iSubjectArea;

    public BaseLastLikeCourseDemand() {
    }

    public BaseLastLikeCourseDemand(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="course_nbr", nullable=false, length=40)
    public String getCourseNbr() {
        return this.iCourseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        this.iCourseNbr = courseNbr;
    }

    @Column(name="priority", nullable=false, length=10)
    public Integer getPriority() {
        return this.iPriority;
    }

    public void setPriority(Integer priority) {
        this.iPriority = priority;
    }

    @Column(name="course_perm_id", nullable=true, length=20)
    public String getCoursePermId() {
        return this.iCoursePermId;
    }

    public void setCoursePermId(String coursePermId) {
        this.iCoursePermId = coursePermId;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="subject_area_id", nullable=false)
    public SubjectArea getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(SubjectArea subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LastLikeCourseDemand)) {
            return false;
        }
        if (this.getUniqueId() == null || ((LastLikeCourseDemand)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((LastLikeCourseDemand)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "LastLikeCourseDemand[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "LastLikeCourseDemand[\n\tCourseNbr: " + this.getCourseNbr() + "\n\tCoursePermId: " + this.getCoursePermId() + "\n\tPriority: " + this.getPriority() + "\n\tStudent: " + this.getStudent() + "\n\tSubjectArea: " + this.getSubjectArea() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

