/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorSurvey;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseInstructorSurvey
extends PreferenceGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iExternalUniqueId;
    private String iEmail;
    private String iNote;
    private Date iSubmitted;
    private String iChangedBy;
    private Date iChanged;
    private String iAppliedDeptCode;
    private Date iApplied;
    private Session iSession;
    private Set<InstructorCourseRequirement> iCourseRequirements;

    public BaseInstructorSurvey() {
    }

    public BaseInstructorSurvey(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="external_uid", nullable=false, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="note", nullable=true, length=2048)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="submitted", nullable=true)
    public Date getSubmitted() {
        return this.iSubmitted;
    }

    public void setSubmitted(Date submitted) {
        this.iSubmitted = submitted;
    }

    @Column(name="changed_by", nullable=true, length=40)
    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    @Column(name="changed_ts", nullable=true)
    public Date getChanged() {
        return this.iChanged;
    }

    public void setChanged(Date changed) {
        this.iChanged = changed;
    }

    @Column(name="applied_dept", nullable=true, length=50)
    public String getAppliedDeptCode() {
        return this.iAppliedDeptCode;
    }

    public void setAppliedDeptCode(String appliedDeptCode) {
        this.iAppliedDeptCode = appliedDeptCode;
    }

    @Column(name="applied_ts", nullable=true)
    public Date getApplied() {
        return this.iApplied;
    }

    public void setApplied(Date applied) {
        this.iApplied = applied;
    }

    @Override
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="session_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @OneToMany(mappedBy="instructorSurvey", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstructorCourseRequirement> getCourseRequirements() {
        return this.iCourseRequirements;
    }

    public void setCourseRequirements(Set<InstructorCourseRequirement> courseRequirements) {
        this.iCourseRequirements = courseRequirements;
    }

    public void addToCourseRequirements(InstructorCourseRequirement instructorCourseRequirement) {
        if (this.iCourseRequirements == null) {
            this.iCourseRequirements = new HashSet<InstructorCourseRequirement>();
        }
        this.iCourseRequirements.add(instructorCourseRequirement);
    }

    @Deprecated
    public void addTocourseRequirements(InstructorCourseRequirement instructorCourseRequirement) {
        this.addToCourseRequirements(instructorCourseRequirement);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructorSurvey)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructorSurvey)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructorSurvey)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "InstructorSurvey[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "InstructorSurvey[\n\tApplied: " + this.getApplied() + "\n\tAppliedDeptCode: " + this.getAppliedDeptCode() + "\n\tChanged: " + this.getChanged() + "\n\tChangedBy: " + this.getChangedBy() + "\n\tEmail: " + this.getEmail() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tNote: " + this.getNote() + "\n\tSession: " + this.getSession() + "\n\tSubmitted: " + this.getSubmitted() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

