/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructorCourseRequirement;
import org.unitime.timetable.model.InstructorCourseRequirementNote;
import org.unitime.timetable.model.InstructorSurvey;

@MappedSuperclass
public abstract class BaseInstructorCourseRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iCourse;
    private InstructorSurvey iInstructorSurvey;
    private CourseOffering iCourseOffering;
    private Set<InstructorCourseRequirementNote> iNotes;

    public BaseInstructorCourseRequirement() {
    }

    public BaseInstructorCourseRequirement(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="course", nullable=true, length=1024)
    public String getCourse() {
        return this.iCourse;
    }

    public void setCourse(String course) {
        this.iCourse = course;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="survey_id", nullable=false)
    public InstructorSurvey getInstructorSurvey() {
        return this.iInstructorSurvey;
    }

    public void setInstructorSurvey(InstructorSurvey instructorSurvey) {
        this.iInstructorSurvey = instructorSurvey;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_offering_id", nullable=true)
    public CourseOffering getCourseOffering() {
        return this.iCourseOffering;
    }

    public void setCourseOffering(CourseOffering courseOffering) {
        this.iCourseOffering = courseOffering;
    }

    @OneToMany(mappedBy="requirement", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<InstructorCourseRequirementNote> getNotes() {
        return this.iNotes;
    }

    public void setNotes(Set<InstructorCourseRequirementNote> notes) {
        this.iNotes = notes;
    }

    public void addToNotes(InstructorCourseRequirementNote instructorCourseRequirementNote) {
        if (this.iNotes == null) {
            this.iNotes = new HashSet<InstructorCourseRequirementNote>();
        }
        this.iNotes.add(instructorCourseRequirementNote);
    }

    @Deprecated
    public void addTonotes(InstructorCourseRequirementNote instructorCourseRequirementNote) {
        this.addToNotes(instructorCourseRequirementNote);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructorCourseRequirement)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructorCourseRequirement)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructorCourseRequirement)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "InstructorCourseRequirement[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "InstructorCourseRequirement[\n\tCourse: " + this.getCourse() + "\n\tCourseOffering: " + this.getCourseOffering() + "\n\tInstructorSurvey: " + this.getInstructorSurvey() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

