/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.SchedulingSubpart;

@MappedSuperclass
public abstract class BaseInstrOfferingConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iLimit;
    private Boolean iUnlimitedEnrollment;
    private String iName;
    private Long iUniqueIdRolledForwardFrom;
    private InstructionalOffering iInstructionalOffering;
    private ClassDurationType iClassDurationType;
    private InstructionalMethod iInstructionalMethod;
    private Set<SchedulingSubpart> iSchedulingSubparts;

    public BaseInstrOfferingConfig() {
    }

    public BaseInstrOfferingConfig(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="instr_offr_config_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="config_limit", nullable=false, length=4)
    public Integer getLimit() {
        return this.iLimit;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    @Column(name="unlimited_enrollment", nullable=false)
    public Boolean isUnlimitedEnrollment() {
        return this.iUnlimitedEnrollment;
    }

    @Transient
    public Boolean getUnlimitedEnrollment() {
        return this.iUnlimitedEnrollment;
    }

    public void setUnlimitedEnrollment(Boolean unlimitedEnrollment) {
        this.iUnlimitedEnrollment = unlimitedEnrollment;
    }

    @Column(name="name", nullable=true, length=20)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="instr_offr_id", nullable=false)
    public InstructionalOffering getInstructionalOffering() {
        return this.iInstructionalOffering;
    }

    public void setInstructionalOffering(InstructionalOffering instructionalOffering) {
        this.iInstructionalOffering = instructionalOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="duration_type_id", nullable=true)
    public ClassDurationType getClassDurationType() {
        return this.iClassDurationType;
    }

    public void setClassDurationType(ClassDurationType classDurationType) {
        this.iClassDurationType = classDurationType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="instr_method_id", nullable=true)
    public InstructionalMethod getInstructionalMethod() {
        return this.iInstructionalMethod;
    }

    public void setInstructionalMethod(InstructionalMethod instructionalMethod) {
        this.iInstructionalMethod = instructionalMethod;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="instrOfferingConfig", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SchedulingSubpart> getSchedulingSubparts() {
        return this.iSchedulingSubparts;
    }

    public void setSchedulingSubparts(Set<SchedulingSubpart> schedulingSubparts) {
        this.iSchedulingSubparts = schedulingSubparts;
    }

    public void addToSchedulingSubparts(SchedulingSubpart schedulingSubpart) {
        if (this.iSchedulingSubparts == null) {
            this.iSchedulingSubparts = new HashSet<SchedulingSubpart>();
        }
        this.iSchedulingSubparts.add(schedulingSubpart);
    }

    @Deprecated
    public void addToschedulingSubparts(SchedulingSubpart schedulingSubpart) {
        this.addToSchedulingSubparts(schedulingSubpart);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstrOfferingConfig)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstrOfferingConfig)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstrOfferingConfig)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "InstrOfferingConfig[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "InstrOfferingConfig[\n\tClassDurationType: " + this.getClassDurationType() + "\n\tInstructionalMethod: " + this.getInstructionalMethod() + "\n\tInstructionalOffering: " + this.getInstructionalOffering() + "\n\tLimit: " + this.getLimit() + "\n\tName: " + this.getName() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "\n\tUnlimitedEnrollment: " + this.getUnlimitedEnrollment() + "]";
    }
}

