/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.IndividualReservation;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.Student;

@MappedSuperclass
public abstract class BaseIndividualReservation
extends Reservation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Student> iStudents;

    public BaseIndividualReservation() {
    }

    public BaseIndividualReservation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_student", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="student_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addToStudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    @Deprecated
    public void addTostudents(Student student) {
        this.addToStudents(student);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof IndividualReservation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((IndividualReservation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((IndividualReservation)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "IndividualReservation[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "IndividualReservation[\n\tExpirationDate: " + this.getExpirationDate() + "\n\tInclusive: " + this.getInclusive() + "\n\tInstructionalOffering: " + this.getInstructionalOffering() + "\n\tLimit: " + this.getLimit() + "\n\tStartDate: " + this.getStartDate() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

