/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.History;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iOldValue;
    private String iNewValue;
    private Session iSession;

    public BaseHistory() {
    }

    public BaseHistory(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="history_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="old_value", nullable=false, length=20)
    public String getOldValue() {
        return this.iOldValue;
    }

    public void setOldValue(String oldValue) {
        this.iOldValue = oldValue;
    }

    @Column(name="new_value", nullable=false, length=20)
    public String getNewValue() {
        return this.iNewValue;
    }

    public void setNewValue(String newValue) {
        this.iNewValue = newValue;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="session_id", nullable=true)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof History)) {
            return false;
        }
        if (this.getUniqueId() == null || ((History)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((History)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "History[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "History[\n\tNewValue: " + this.getNewValue() + "\n\tOldValue: " + this.getOldValue() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

