/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomFeature;

@MappedSuperclass
public abstract class BaseExternalRoomFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iValue;
    private ExternalRoom iRoom;

    public BaseExternalRoomFeature() {
    }

    public BaseExternalRoomFeature(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=20)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="value", nullable=false, length=20)
    public String getValue() {
        return this.iValue;
    }

    public void setValue(String value) {
        this.iValue = value;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="external_room_id", nullable=false)
    public ExternalRoom getRoom() {
        return this.iRoom;
    }

    public void setRoom(ExternalRoom room) {
        this.iRoom = room;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExternalRoomFeature)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExternalRoomFeature)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExternalRoomFeature)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExternalRoomFeature[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "ExternalRoomFeature[\n\tName: " + this.getName() + "\n\tRoom: " + this.getRoom() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tValue: " + this.getValue() + "]";
    }
}

