/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ExternalRoom;
import org.unitime.timetable.model.ExternalRoomDepartment;

@MappedSuperclass
public abstract class BaseExternalRoomDepartment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iDepartmentCode;
    private Integer iPercent;
    private String iAssignmentType;
    private ExternalRoom iRoom;

    public BaseExternalRoomDepartment() {
    }

    public BaseExternalRoomDepartment(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="department_code", nullable=false, length=50)
    public String getDepartmentCode() {
        return this.iDepartmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.iDepartmentCode = departmentCode;
    }

    @Column(name="percent", nullable=false, length=3)
    public Integer getPercent() {
        return this.iPercent;
    }

    public void setPercent(Integer percent) {
        this.iPercent = percent;
    }

    @Column(name="assignment_type", nullable=false, length=20)
    public String getAssignmentType() {
        return this.iAssignmentType;
    }

    public void setAssignmentType(String assignmentType) {
        this.iAssignmentType = assignmentType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="external_room_id", nullable=false)
    public ExternalRoom getRoom() {
        return this.iRoom;
    }

    public void setRoom(ExternalRoom room) {
        this.iRoom = room;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExternalRoomDepartment)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExternalRoomDepartment)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExternalRoomDepartment)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExternalRoomDepartment[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExternalRoomDepartment[\n\tAssignmentType: " + this.getAssignmentType() + "\n\tDepartmentCode: " + this.getDepartmentCode() + "\n\tPercent: " + this.getPercent() + "\n\tRoom: " + this.getRoom() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

