/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.ExamStatusId;

@MappedSuperclass
@IdClass(value=ExamStatusId.class)
public abstract class BaseExamStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Session iSession;
    private ExamType iType;
    private DepartmentStatusType iStatus;
    private Set<TimetableManager> iManagers;

    @Id
    @ManyToOne(optional=false)
    @JoinColumn(name="session_id")
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @Id
    @ManyToOne(optional=false)
    @JoinColumn(name="type_id")
    public ExamType getType() {
        return this.iType;
    }

    public void setType(ExamType type) {
        this.iType = type;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="status_id", nullable=true)
    public DepartmentStatusType getStatus() {
        return this.iStatus;
    }

    public void setStatus(DepartmentStatusType status) {
        this.iStatus = status;
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="exam_managers", joinColumns={@JoinColumn(name="session_id"), @JoinColumn(name="type_id")}, inverseJoinColumns={@JoinColumn(name="manager_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TimetableManager> getManagers() {
        return this.iManagers;
    }

    public void setManagers(Set<TimetableManager> managers) {
        this.iManagers = managers;
    }

    public void addToManagers(TimetableManager timetableManager) {
        if (this.iManagers == null) {
            this.iManagers = new HashSet<TimetableManager>();
        }
        this.iManagers.add(timetableManager);
    }

    @Deprecated
    public void addTomanagers(TimetableManager timetableManager) {
        this.addToManagers(timetableManager);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamStatus)) {
            return false;
        }
        ExamStatus examStatus = (ExamStatus)o;
        if (this.getSession() == null || examStatus.getSession() == null || !this.getSession().equals(examStatus.getSession())) {
            return false;
        }
        return this.getType() != null && examStatus.getType() != null && this.getType().equals(examStatus.getType());
    }

    public int hashCode() {
        if (this.getSession() == null || this.getType() == null) {
            return super.hashCode();
        }
        return this.getSession().hashCode() ^ this.getType().hashCode();
    }

    public String toString() {
        return "ExamStatus[" + this.getSession() + ", " + this.getType() + "]";
    }

    public String toDebugString() {
        return "ExamStatus[\n\tSession: " + this.getSession() + "\n\tStatus: " + this.getStatus() + "\n\tType: " + this.getType() + "]";
    }
}

