/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseExamPeriod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iDateOffset;
    private Integer iStartSlot;
    private Integer iLength;
    private Integer iEventStartOffset;
    private Integer iEventStopOffset;
    private Session iSession;
    private ExamType iExamType;
    private PreferenceLevel iPrefLevel;

    public BaseExamPeriod() {
    }

    public BaseExamPeriod(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="date_ofs", nullable=false, length=10)
    public Integer getDateOffset() {
        return this.iDateOffset;
    }

    public void setDateOffset(Integer dateOffset) {
        this.iDateOffset = dateOffset;
    }

    @Column(name="start_slot", nullable=false, length=10)
    public Integer getStartSlot() {
        return this.iStartSlot;
    }

    public void setStartSlot(Integer startSlot) {
        this.iStartSlot = startSlot;
    }

    @Column(name="length", nullable=false, length=10)
    public Integer getLength() {
        return this.iLength;
    }

    public void setLength(Integer length) {
        this.iLength = length;
    }

    @Column(name="event_start_offset", nullable=false, length=10)
    public Integer getEventStartOffset() {
        return this.iEventStartOffset;
    }

    public void setEventStartOffset(Integer eventStartOffset) {
        this.iEventStartOffset = eventStartOffset;
    }

    @Column(name="event_stop_offset", nullable=false, length=10)
    public Integer getEventStopOffset() {
        return this.iEventStopOffset;
    }

    public void setEventStopOffset(Integer eventStopOffset) {
        this.iEventStopOffset = eventStopOffset;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="session_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="exam_type_id", nullable=false)
    public ExamType getExamType() {
        return this.iExamType;
    }

    public void setExamType(ExamType examType) {
        this.iExamType = examType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pref_level_id", nullable=false)
    public PreferenceLevel getPrefLevel() {
        return this.iPrefLevel;
    }

    public void setPrefLevel(PreferenceLevel prefLevel) {
        this.iPrefLevel = prefLevel;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamPeriod)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExamPeriod)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExamPeriod)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExamPeriod[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExamPeriod[\n\tDateOffset: " + this.getDateOffset() + "\n\tEventStartOffset: " + this.getEventStartOffset() + "\n\tEventStopOffset: " + this.getEventStopOffset() + "\n\tExamType: " + this.getExamType() + "\n\tLength: " + this.getLength() + "\n\tPrefLevel: " + this.getPrefLevel() + "\n\tSession: " + this.getSession() + "\n\tStartSlot: " + this.getStartSlot() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

