/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseEventDateMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iClassDateOffset;
    private Integer iEventDateOffset;
    private String iNote;
    private Session iSession;

    public BaseEventDateMapping() {
    }

    public BaseEventDateMapping(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="class_date", nullable=true)
    public Integer getClassDateOffset() {
        return this.iClassDateOffset;
    }

    public void setClassDateOffset(Integer classDateOffset) {
        this.iClassDateOffset = classDateOffset;
    }

    @Column(name="event_date", nullable=true)
    public Integer getEventDateOffset() {
        return this.iEventDateOffset;
    }

    public void setEventDateOffset(Integer eventDateOffset) {
        this.iEventDateOffset = eventDateOffset;
    }

    @Column(name="note", nullable=true, length=1000)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EventDateMapping)) {
            return false;
        }
        if (this.getUniqueId() == null || ((EventDateMapping)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((EventDateMapping)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "EventDateMapping[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "EventDateMapping[\n\tClassDateOffset: " + this.getClassDateOffset() + "\n\tEventDateOffset: " + this.getEventDateOffset() + "\n\tNote: " + this.getNote() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

