/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.SponsoringOrganization;

@MappedSuperclass
public abstract class BaseEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iEventName;
    private Integer iMinCapacity;
    private Integer iMaxCapacity;
    private String iEmail;
    private Date iExpirationDate;
    private Integer iExamStatus;
    private Long iDepartmentId;
    private EventContact iMainContact;
    private SponsoringOrganization iSponsoringOrganization;
    private Set<EventContact> iAdditionalContacts;
    private Set<EventNote> iNotes;
    private Set<Meeting> iMeetings;
    private Set<EventServiceProvider> iRequestedServices;

    public BaseEvent() {
    }

    public BaseEvent(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="event_name", nullable=true, length=100)
    public String getEventName() {
        return this.iEventName;
    }

    public void setEventName(String eventName) {
        this.iEventName = eventName;
    }

    @Column(name="min_capacity", nullable=true, length=10)
    public Integer getMinCapacity() {
        return this.iMinCapacity;
    }

    public void setMinCapacity(Integer minCapacity) {
        this.iMinCapacity = minCapacity;
    }

    @Column(name="max_capacity", nullable=true, length=10)
    public Integer getMaxCapacity() {
        return this.iMaxCapacity;
    }

    public void setMaxCapacity(Integer maxCapacity) {
        this.iMaxCapacity = maxCapacity;
    }

    @Column(name="email", nullable=true, length=1000)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="expiration_date", nullable=true)
    public Date getExpirationDate() {
        return this.iExpirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.iExpirationDate = expirationDate;
    }

    @Formula(value=" ( select t.status from %SCHEMA%.exam x, %SCHEMA%.exam_status s, %SCHEMA%.dept_status_type t where x.uniqueid = exam_id and s.session_id = x.session_id and s.type_id = x.exam_type_id and s.status_id = t.uniqueid) ")
    public Integer getExamStatus() {
        return this.iExamStatus;
    }

    public void setExamStatus(Integer examStatus) {
        this.iExamStatus = examStatus;
    }

    @Formula(value=" ( select sa.department_uniqueid from %SCHEMA%.class_ c, %SCHEMA%.scheduling_subpart ss, %SCHEMA%.instr_offering_config ioc, %SCHEMA%.instructional_offering io, %SCHEMA%.course_offering co, %SCHEMA%.subject_area sa where c.uniqueid = class_id and ss.uniqueid = c.subpart_id and ioc.uniqueid = ss.config_id and io.uniqueid = ioc.instr_offr_id and co.instr_offr_id = io.uniqueid and co.is_control = %TRUE% and sa.uniqueid = co.subject_area_id ) ")
    public Long getDepartmentId() {
        return this.iDepartmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.iDepartmentId = departmentId;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="main_contact_id", nullable=true)
    public EventContact getMainContact() {
        return this.iMainContact;
    }

    public void setMainContact(EventContact mainContact) {
        this.iMainContact = mainContact;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="sponsor_org_id", nullable=true)
    public SponsoringOrganization getSponsoringOrganization() {
        return this.iSponsoringOrganization;
    }

    public void setSponsoringOrganization(SponsoringOrganization sponsoringOrganization) {
        this.iSponsoringOrganization = sponsoringOrganization;
    }

    @ManyToMany
    @JoinTable(name="event_join_event_contact", joinColumns={@JoinColumn(name="event_id")}, inverseJoinColumns={@JoinColumn(name="event_contact_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<EventContact> getAdditionalContacts() {
        return this.iAdditionalContacts;
    }

    public void setAdditionalContacts(Set<EventContact> additionalContacts) {
        this.iAdditionalContacts = additionalContacts;
    }

    public void addToAdditionalContacts(EventContact eventContact) {
        if (this.iAdditionalContacts == null) {
            this.iAdditionalContacts = new HashSet<EventContact>();
        }
        this.iAdditionalContacts.add(eventContact);
    }

    @Deprecated
    public void addToadditionalContacts(EventContact eventContact) {
        this.addToAdditionalContacts(eventContact);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="event", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<EventNote> getNotes() {
        return this.iNotes;
    }

    public void setNotes(Set<EventNote> notes) {
        this.iNotes = notes;
    }

    public void addToNotes(EventNote eventNote) {
        if (this.iNotes == null) {
            this.iNotes = new HashSet<EventNote>();
        }
        this.iNotes.add(eventNote);
    }

    @Deprecated
    public void addTonotes(EventNote eventNote) {
        this.addToNotes(eventNote);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="event", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Meeting> getMeetings() {
        return this.iMeetings;
    }

    public void setMeetings(Set<Meeting> meetings) {
        this.iMeetings = meetings;
    }

    public void addToMeetings(Meeting meeting) {
        if (this.iMeetings == null) {
            this.iMeetings = new HashSet<Meeting>();
        }
        this.iMeetings.add(meeting);
    }

    @Deprecated
    public void addTomeetings(Meeting meeting) {
        this.addToMeetings(meeting);
    }

    @ManyToMany
    @JoinTable(name="event_service_provider", joinColumns={@JoinColumn(name="event_id")}, inverseJoinColumns={@JoinColumn(name="provider_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<EventServiceProvider> getRequestedServices() {
        return this.iRequestedServices;
    }

    public void setRequestedServices(Set<EventServiceProvider> requestedServices) {
        this.iRequestedServices = requestedServices;
    }

    public void addToRequestedServices(EventServiceProvider eventServiceProvider) {
        if (this.iRequestedServices == null) {
            this.iRequestedServices = new HashSet<EventServiceProvider>();
        }
        this.iRequestedServices.add(eventServiceProvider);
    }

    @Deprecated
    public void addTorequestedServices(EventServiceProvider eventServiceProvider) {
        this.addToRequestedServices(eventServiceProvider);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Event)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Event)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Event)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Event[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Event[\n\tEmail: " + this.getEmail() + "\n\tEventName: " + this.getEventName() + "\n\tExpirationDate: " + this.getExpirationDate() + "\n\tMainContact: " + this.getMainContact() + "\n\tMaxCapacity: " + this.getMaxCapacity() + "\n\tMinCapacity: " + this.getMinCapacity() + "\n\tSponsoringOrganization: " + this.getSponsoringOrganization() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

