/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Preference;

@MappedSuperclass
public abstract class BaseDistributionPref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer iGrouping;
    private Long iUniqueIdRolledForwardFrom;
    private DistributionType iDistributionType;
    private Set<DistributionObject> iDistributionObjects;

    public BaseDistributionPref() {
    }

    public BaseDistributionPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Column(name="dist_grouping", nullable=true, length=4)
    public Integer getGrouping() {
        return this.iGrouping;
    }

    public void setGrouping(Integer grouping) {
        this.iGrouping = grouping;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="dist_type_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public DistributionType getDistributionType() {
        return this.iDistributionType;
    }

    public void setDistributionType(DistributionType distributionType) {
        this.iDistributionType = distributionType;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="distributionPref", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DistributionObject> getDistributionObjects() {
        return this.iDistributionObjects;
    }

    public void setDistributionObjects(Set<DistributionObject> distributionObjects) {
        this.iDistributionObjects = distributionObjects;
    }

    public void addToDistributionObjects(DistributionObject distributionObject) {
        if (this.iDistributionObjects == null) {
            this.iDistributionObjects = new HashSet<DistributionObject>();
        }
        this.iDistributionObjects.add(distributionObject);
    }

    @Deprecated
    public void addTodistributionObjects(DistributionObject distributionObject) {
        this.addToDistributionObjects(distributionObject);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DistributionPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DistributionPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DistributionPref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "DistributionPref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "DistributionPref[\n\tDistributionType: " + this.getDistributionType() + "\n\tGrouping: " + this.getGrouping() + "\n\tNote: " + this.getNote() + "\n\tOwner: " + this.getOwner() + "\n\tPrefLevel: " + this.getPrefLevel() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

