/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.proxy.HibernateProxy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.PreferenceGroup;

@MappedSuperclass
public abstract class BaseDistributionObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iSequenceNumber;
    private DistributionPref iDistributionPref;
    private PreferenceGroup iPrefGroup;

    public BaseDistributionObject() {
    }

    public BaseDistributionObject(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="dist_obj_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="sequence_number", nullable=true, length=2)
    public Integer getSequenceNumber() {
        return this.iSequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.iSequenceNumber = sequenceNumber;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="dist_pref_id", nullable=false)
    public DistributionPref getDistributionPref() {
        return this.iDistributionPref;
    }

    public void setDistributionPref(DistributionPref distributionPref) {
        this.iDistributionPref = distributionPref;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="pref_group_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public PreferenceGroup getPrefGroup() {
        if (this.iPrefGroup != null && this.iPrefGroup instanceof HibernateProxy) {
            this.iPrefGroup = (PreferenceGroup)Hibernate.unproxy((Object)this.iPrefGroup);
        }
        return this.iPrefGroup;
    }

    public void setPrefGroup(PreferenceGroup prefGroup) {
        this.iPrefGroup = prefGroup;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DistributionObject)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DistributionObject)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DistributionObject)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "DistributionObject[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "DistributionObject[\n\tDistributionPref: " + this.getDistributionPref() + "\n\tPrefGroup: " + this.getPrefGroup() + "\n\tSequenceNumber: " + this.getSequenceNumber() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

