/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.Preference;

@MappedSuperclass
public abstract class BaseDatePatternPref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DatePattern iDatePattern;

    public BaseDatePatternPref() {
    }

    public BaseDatePatternPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="date_pattern_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public DatePattern getDatePattern() {
        return this.iDatePattern;
    }

    public void setDatePattern(DatePattern datePattern) {
        this.iDatePattern = datePattern;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof DatePatternPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DatePatternPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DatePatternPref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "DatePatternPref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "DatePatternPref[\n\tDatePattern: " + this.getDatePattern() + "\n\tNote: " + this.getNote() + "\n\tOwner: " + this.getOwner() + "\n\tPrefLevel: " + this.getPrefLevel() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

