/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseDatePattern
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iPattern;
    private Integer iOffset;
    private Integer iType;
    private Boolean iVisible;
    private Float iNumberOfWeeks;
    private Session iSession;
    private Set<DatePattern> iParents;
    private Set<DatePattern> iChildren;
    private Set<Department> iDepartments;

    public BaseDatePattern() {
    }

    public BaseDatePattern(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="date_pattern_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=true, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="pattern", nullable=false, length=366)
    public String getPattern() {
        return this.iPattern;
    }

    public void setPattern(String pattern) {
        this.iPattern = pattern;
    }

    @Column(name="offset", nullable=false, length=4)
    public Integer getOffset() {
        return this.iOffset;
    }

    public void setOffset(Integer offset) {
        this.iOffset = offset;
    }

    @Column(name="type", nullable=true, length=2)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @Column(name="visible", nullable=true)
    public Boolean isVisible() {
        return this.iVisible;
    }

    @Transient
    public Boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(Boolean visible) {
        this.iVisible = visible;
    }

    @Column(name="nr_weeks", nullable=true)
    public Float getNumberOfWeeks() {
        return this.iNumberOfWeeks;
    }

    public void setNumberOfWeeks(Float numberOfWeeks) {
        this.iNumberOfWeeks = numberOfWeeks;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="session_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany
    @JoinTable(name="date_pattern_parent", joinColumns={@JoinColumn(name="date_pattern_id")}, inverseJoinColumns={@JoinColumn(name="parent_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DatePattern> getParents() {
        return this.iParents;
    }

    public void setParents(Set<DatePattern> parents) {
        this.iParents = parents;
    }

    public void addToParents(DatePattern datePattern) {
        if (this.iParents == null) {
            this.iParents = new HashSet<DatePattern>();
        }
        this.iParents.add(datePattern);
    }

    @Deprecated
    public void addToparents(DatePattern datePattern) {
        this.addToParents(datePattern);
    }

    @ManyToMany(mappedBy="parents")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DatePattern> getChildren() {
        return this.iChildren;
    }

    public void setChildren(Set<DatePattern> children) {
        this.iChildren = children;
    }

    public void addToChildren(DatePattern datePattern) {
        if (this.iChildren == null) {
            this.iChildren = new HashSet<DatePattern>();
        }
        this.iChildren.add(datePattern);
    }

    @Deprecated
    public void addTochildren(DatePattern datePattern) {
        this.addToChildren(datePattern);
    }

    @ManyToMany(mappedBy="datePatterns")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addToDepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    @Deprecated
    public void addTodepartments(Department department) {
        this.addToDepartments(department);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DatePattern)) {
            return false;
        }
        if (this.getUniqueId() == null || ((DatePattern)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((DatePattern)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "DatePattern[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "DatePattern[\n\tName: " + this.getName() + "\n\tNumberOfWeeks: " + this.getNumberOfWeeks() + "\n\tOffset: " + this.getOffset() + "\n\tPattern: " + this.getPattern() + "\n\tSession: " + this.getSession() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tVisible: " + this.getVisible() + "]";
    }
}

