/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CurriculumReservation;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Reservation;

@MappedSuperclass
public abstract class BaseCurriculumReservation
extends Reservation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<AcademicArea> iAreas;
    private Set<PosMajor> iMajors;
    private Set<PosMajorConcentration> iConcentrations;
    private Set<AcademicClassification> iClassifications;
    private Set<PosMinor> iMinors;

    public BaseCurriculumReservation() {
    }

    public BaseCurriculumReservation(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_acad_area", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="area_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<AcademicArea> getAreas() {
        return this.iAreas;
    }

    public void setAreas(Set<AcademicArea> areas) {
        this.iAreas = areas;
    }

    public void addToAreas(AcademicArea academicArea) {
        if (this.iAreas == null) {
            this.iAreas = new HashSet<AcademicArea>();
        }
        this.iAreas.add(academicArea);
    }

    @Deprecated
    public void addToareas(AcademicArea academicArea) {
        this.addToAreas(academicArea);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_major", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="major_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMajor> getMajors() {
        return this.iMajors;
    }

    public void setMajors(Set<PosMajor> majors) {
        this.iMajors = majors;
    }

    public void addToMajors(PosMajor posMajor) {
        if (this.iMajors == null) {
            this.iMajors = new HashSet<PosMajor>();
        }
        this.iMajors.add(posMajor);
    }

    @Deprecated
    public void addTomajors(PosMajor posMajor) {
        this.addToMajors(posMajor);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_major_conc", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="concentration_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMajorConcentration> getConcentrations() {
        return this.iConcentrations;
    }

    public void setConcentrations(Set<PosMajorConcentration> concentrations) {
        this.iConcentrations = concentrations;
    }

    public void addToConcentrations(PosMajorConcentration posMajorConcentration) {
        if (this.iConcentrations == null) {
            this.iConcentrations = new HashSet<PosMajorConcentration>();
        }
        this.iConcentrations.add(posMajorConcentration);
    }

    @Deprecated
    public void addToconcentrations(PosMajorConcentration posMajorConcentration) {
        this.addToConcentrations(posMajorConcentration);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_clasf", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="acad_clasf_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<AcademicClassification> getClassifications() {
        return this.iClassifications;
    }

    public void setClassifications(Set<AcademicClassification> classifications) {
        this.iClassifications = classifications;
    }

    public void addToClassifications(AcademicClassification academicClassification) {
        if (this.iClassifications == null) {
            this.iClassifications = new HashSet<AcademicClassification>();
        }
        this.iClassifications.add(academicClassification);
    }

    @Deprecated
    public void addToclassifications(AcademicClassification academicClassification) {
        this.addToClassifications(academicClassification);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="reservation_minor", joinColumns={@JoinColumn(name="reservation_id")}, inverseJoinColumns={@JoinColumn(name="minor_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMinor> getMinors() {
        return this.iMinors;
    }

    public void setMinors(Set<PosMinor> minors) {
        this.iMinors = minors;
    }

    public void addToMinors(PosMinor posMinor) {
        if (this.iMinors == null) {
            this.iMinors = new HashSet<PosMinor>();
        }
        this.iMinors.add(posMinor);
    }

    @Deprecated
    public void addTominors(PosMinor posMinor) {
        this.addToMinors(posMinor);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumReservation)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CurriculumReservation)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CurriculumReservation)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "CurriculumReservation[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "CurriculumReservation[\n\tExpirationDate: " + this.getExpirationDate() + "\n\tInclusive: " + this.getInclusive() + "\n\tInstructionalOffering: " + this.getInstructionalOffering() + "\n\tLimit: " + this.getLimit() + "\n\tStartDate: " + this.getStartDate() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

