/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CurriculumProjectionRule;
import org.unitime.timetable.model.PosMajor;

@MappedSuperclass
public abstract class BaseCurriculumProjectionRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Float iProjection;
    private Float iSnapshotProjection;
    private Date iSnapshotProjectedDate;
    private AcademicArea iAcademicArea;
    private PosMajor iMajor;
    private AcademicClassification iAcademicClassification;

    public BaseCurriculumProjectionRule() {
    }

    public BaseCurriculumProjectionRule(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="projection", nullable=false)
    public Float getProjection() {
        return this.iProjection;
    }

    public void setProjection(Float projection) {
        this.iProjection = projection;
    }

    @Column(name="snapshot_proj", nullable=true)
    public Float getSnapshotProjection() {
        return this.iSnapshotProjection;
    }

    public void setSnapshotProjection(Float snapshotProjection) {
        this.iSnapshotProjection = snapshotProjection;
    }

    @Column(name="snapshot_proj_date", nullable=true)
    public Date getSnapshotProjectedDate() {
        return this.iSnapshotProjectedDate;
    }

    public void setSnapshotProjectedDate(Date snapshotProjectedDate) {
        this.iSnapshotProjectedDate = snapshotProjectedDate;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_area_id", nullable=false)
    public AcademicArea getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(AcademicArea academicArea) {
        this.iAcademicArea = academicArea;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="major_id", nullable=true)
    public PosMajor getMajor() {
        return this.iMajor;
    }

    public void setMajor(PosMajor major) {
        this.iMajor = major;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_clasf_id", nullable=false)
    public AcademicClassification getAcademicClassification() {
        return this.iAcademicClassification;
    }

    public void setAcademicClassification(AcademicClassification academicClassification) {
        this.iAcademicClassification = academicClassification;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumProjectionRule)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CurriculumProjectionRule)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CurriculumProjectionRule)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CurriculumProjectionRule[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CurriculumProjectionRule[\n\tAcademicArea: " + this.getAcademicArea() + "\n\tAcademicClassification: " + this.getAcademicClassification() + "\n\tMajor: " + this.getMajor() + "\n\tProjection: " + this.getProjection() + "\n\tSnapshotProjectedDate: " + this.getSnapshotProjectedDate() + "\n\tSnapshotProjection: " + this.getSnapshotProjection() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

