/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumCourseGroup;

@MappedSuperclass
public abstract class BaseCurriculumCourseGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iColor;
    private Integer iType;
    private Curriculum iCurriculum;

    public BaseCurriculumCourseGroup() {
    }

    public BaseCurriculumCourseGroup(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=20)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="color", nullable=true, length=20)
    public String getColor() {
        return this.iColor;
    }

    public void setColor(String color) {
        this.iColor = color;
    }

    @Column(name="type", nullable=false)
    public Integer getType() {
        return this.iType;
    }

    public void setType(Integer type) {
        this.iType = type;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="curriculum_id", nullable=false)
    public Curriculum getCurriculum() {
        return this.iCurriculum;
    }

    public void setCurriculum(Curriculum curriculum) {
        this.iCurriculum = curriculum;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumCourseGroup)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CurriculumCourseGroup)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CurriculumCourseGroup)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CurriculumCourseGroup[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "CurriculumCourseGroup[\n\tColor: " + this.getColor() + "\n\tCurriculum: " + this.getCurriculum() + "\n\tName: " + this.getName() + "\n\tType: " + this.getType() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

