/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Curriculum;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.CurriculumCourse;

@MappedSuperclass
public abstract class BaseCurriculumClassification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private Integer iNrStudents;
    private Integer iOrd;
    private String iStudents;
    private Integer iSnapshotNrStudents;
    private Date iSnapshotNrStudentsDate;
    private Curriculum iCurriculum;
    private AcademicClassification iAcademicClassification;
    private Set<CurriculumCourse> iCourses;

    public BaseCurriculumClassification() {
    }

    public BaseCurriculumClassification(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=20)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="nr_students", nullable=false)
    public Integer getNrStudents() {
        return this.iNrStudents;
    }

    public void setNrStudents(Integer nrStudents) {
        this.iNrStudents = nrStudents;
    }

    @Column(name="ord", nullable=false)
    public Integer getOrd() {
        return this.iOrd;
    }

    public void setOrd(Integer ord) {
        this.iOrd = ord;
    }

    @Column(name="students", nullable=true)
    public String getStudents() {
        return this.iStudents;
    }

    public void setStudents(String students) {
        this.iStudents = students;
    }

    @Column(name="snapshot_nr_students", nullable=true)
    public Integer getSnapshotNrStudents() {
        return this.iSnapshotNrStudents;
    }

    public void setSnapshotNrStudents(Integer snapshotNrStudents) {
        this.iSnapshotNrStudents = snapshotNrStudents;
    }

    @Column(name="snapshot_nr_stu_date", nullable=true)
    public Date getSnapshotNrStudentsDate() {
        return this.iSnapshotNrStudentsDate;
    }

    public void setSnapshotNrStudentsDate(Date snapshotNrStudentsDate) {
        this.iSnapshotNrStudentsDate = snapshotNrStudentsDate;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="curriculum_id", nullable=false)
    public Curriculum getCurriculum() {
        return this.iCurriculum;
    }

    public void setCurriculum(Curriculum curriculum) {
        this.iCurriculum = curriculum;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="acad_clasf_id", nullable=false)
    public AcademicClassification getAcademicClassification() {
        return this.iAcademicClassification;
    }

    public void setAcademicClassification(AcademicClassification academicClassification) {
        this.iAcademicClassification = academicClassification;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="classification", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CurriculumCourse> getCourses() {
        return this.iCourses;
    }

    public void setCourses(Set<CurriculumCourse> courses) {
        this.iCourses = courses;
    }

    public void addToCourses(CurriculumCourse curriculumCourse) {
        if (this.iCourses == null) {
            this.iCourses = new HashSet<CurriculumCourse>();
        }
        this.iCourses.add(curriculumCourse);
    }

    @Deprecated
    public void addTocourses(CurriculumCourse curriculumCourse) {
        this.addToCourses(curriculumCourse);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CurriculumClassification)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CurriculumClassification)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CurriculumClassification)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CurriculumClassification[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "CurriculumClassification[\n\tAcademicClassification: " + this.getAcademicClassification() + "\n\tCurriculum: " + this.getCurriculum() + "\n\tName: " + this.getName() + "\n\tNrStudents: " + this.getNrStudents() + "\n\tOrd: " + this.getOrd() + "\n\tSnapshotNrStudents: " + this.getSnapshotNrStudents() + "\n\tSnapshotNrStudentsDate: " + this.getSnapshotNrStudentsDate() + "\n\tStudents: " + this.getStudents() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

