/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.CourseRequestOption;

@MappedSuperclass
public abstract class BaseCourseRequestOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iOptionType;
    private byte[] iValue;
    private CourseRequest iCourseRequest;

    public BaseCourseRequestOption() {
    }

    public BaseCourseRequestOption(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="option_type", nullable=false, length=10)
    public Integer getOptionType() {
        return this.iOptionType;
    }

    public void setOptionType(Integer optionType) {
        this.iOptionType = optionType;
    }

    @Column(name="value", nullable=false)
    public byte[] getValue() {
        return this.iValue;
    }

    public void setValue(byte[] value) {
        this.iValue = value;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="course_request_id", nullable=false)
    public CourseRequest getCourseRequest() {
        return this.iCourseRequest;
    }

    public void setCourseRequest(CourseRequest courseRequest) {
        this.iCourseRequest = courseRequest;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseRequestOption)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseRequestOption)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseRequestOption)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseRequestOption[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseRequestOption[\n\tCourseRequest: " + this.getCourseRequest() + "\n\tOptionType: " + this.getOptionType() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tValue: " + this.getValue() + "]";
    }
}

