/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseDemand;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentEnrollmentMessage;

@MappedSuperclass
public abstract class BaseCourseDemand
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPriority;
    private Boolean iWaitlist;
    private Boolean iNoSub;
    private Boolean iAlternative;
    private Date iTimestamp;
    private Integer iCritical;
    private Integer iCriticalOverride;
    private Date iWaitlistedTimeStamp;
    private String iChangedBy;
    private Student iStudent;
    private CourseOffering iWaitListSwapWithCourseOffering;
    private FreeTime iFreeTime;
    private Set<CourseRequest> iCourseRequests;
    private Set<StudentEnrollmentMessage> iEnrollmentMessages;

    public BaseCourseDemand() {
    }

    public BaseCourseDemand(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="priority", nullable=false, length=10)
    public Integer getPriority() {
        return this.iPriority;
    }

    public void setPriority(Integer priority) {
        this.iPriority = priority;
    }

    @Column(name="waitlist", nullable=false)
    public Boolean isWaitlist() {
        return this.iWaitlist;
    }

    @Transient
    public Boolean getWaitlist() {
        return this.iWaitlist;
    }

    public void setWaitlist(Boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    @Column(name="nosub", nullable=true)
    public Boolean isNoSub() {
        return this.iNoSub;
    }

    @Transient
    public Boolean getNoSub() {
        return this.iNoSub;
    }

    public void setNoSub(Boolean noSub) {
        this.iNoSub = noSub;
    }

    @Column(name="is_alternative", nullable=false)
    public Boolean isAlternative() {
        return this.iAlternative;
    }

    @Transient
    public Boolean getAlternative() {
        return this.iAlternative;
    }

    public void setAlternative(Boolean alternative) {
        this.iAlternative = alternative;
    }

    @Column(name="timestamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @Column(name="critical", nullable=true)
    public Integer getCritical() {
        return this.iCritical;
    }

    public void setCritical(Integer critical) {
        this.iCritical = critical;
    }

    @Column(name="critical_override", nullable=true)
    public Integer getCriticalOverride() {
        return this.iCriticalOverride;
    }

    public void setCriticalOverride(Integer criticalOverride) {
        this.iCriticalOverride = criticalOverride;
    }

    @Column(name="waitlist_ts", nullable=true)
    public Date getWaitlistedTimeStamp() {
        return this.iWaitlistedTimeStamp;
    }

    public void setWaitlistedTimeStamp(Date waitlistedTimeStamp) {
        this.iWaitlistedTimeStamp = waitlistedTimeStamp;
    }

    @Column(name="changed_by", nullable=true, length=40)
    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="wl_course_swap_id", nullable=true)
    public CourseOffering getWaitListSwapWithCourseOffering() {
        return this.iWaitListSwapWithCourseOffering;
    }

    public void setWaitListSwapWithCourseOffering(CourseOffering waitListSwapWithCourseOffering) {
        this.iWaitListSwapWithCourseOffering = waitListSwapWithCourseOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="free_time_id", nullable=true)
    public FreeTime getFreeTime() {
        return this.iFreeTime;
    }

    public void setFreeTime(FreeTime freeTime) {
        this.iFreeTime = freeTime;
    }

    @OneToMany(mappedBy="courseDemand", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseRequest> getCourseRequests() {
        return this.iCourseRequests;
    }

    public void setCourseRequests(Set<CourseRequest> courseRequests) {
        this.iCourseRequests = courseRequests;
    }

    public void addToCourseRequests(CourseRequest courseRequest) {
        if (this.iCourseRequests == null) {
            this.iCourseRequests = new HashSet<CourseRequest>();
        }
        this.iCourseRequests.add(courseRequest);
    }

    @Deprecated
    public void addTocourseRequests(CourseRequest courseRequest) {
        this.addToCourseRequests(courseRequest);
    }

    @OneToMany(mappedBy="courseDemand", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<StudentEnrollmentMessage> getEnrollmentMessages() {
        return this.iEnrollmentMessages;
    }

    public void setEnrollmentMessages(Set<StudentEnrollmentMessage> enrollmentMessages) {
        this.iEnrollmentMessages = enrollmentMessages;
    }

    public void addToEnrollmentMessages(StudentEnrollmentMessage studentEnrollmentMessage) {
        if (this.iEnrollmentMessages == null) {
            this.iEnrollmentMessages = new HashSet<StudentEnrollmentMessage>();
        }
        this.iEnrollmentMessages.add(studentEnrollmentMessage);
    }

    @Deprecated
    public void addToenrollmentMessages(StudentEnrollmentMessage studentEnrollmentMessage) {
        this.addToEnrollmentMessages(studentEnrollmentMessage);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseDemand)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseDemand)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseDemand)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseDemand[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseDemand[\n\tAlternative: " + this.getAlternative() + "\n\tChangedBy: " + this.getChangedBy() + "\n\tCritical: " + this.getCritical() + "\n\tCriticalOverride: " + this.getCriticalOverride() + "\n\tFreeTime: " + this.getFreeTime() + "\n\tNoSub: " + this.getNoSub() + "\n\tPriority: " + this.getPriority() + "\n\tStudent: " + this.getStudent() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tWaitListSwapWithCourseOffering: " + this.getWaitListSwapWithCourseOffering() + "\n\tWaitlist: " + this.getWaitlist() + "\n\tWaitlistedTimeStamp: " + this.getWaitlistedTimeStamp() + "]";
    }
}

