/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.JoinFormula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseCreditFormat;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.SchedulingSubpart;

@MappedSuperclass
public abstract class BaseCourseCreditUnitConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Boolean iDefinesCreditAtCourseLevel;
    private CourseCreditFormat iCourseCreditFormat;
    private CourseCreditType iCreditType;
    private CourseCreditUnitType iCreditUnitType;
    private SchedulingSubpart iSubpartOwner;
    private CourseOffering iCourseOwner;

    public BaseCourseCreditUnitConfig() {
    }

    public BaseCourseCreditUnitConfig(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="crs_credit_unig_cfg_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="defines_credit_at_course_level", nullable=false)
    public Boolean isDefinesCreditAtCourseLevel() {
        return this.iDefinesCreditAtCourseLevel;
    }

    @Transient
    public Boolean getDefinesCreditAtCourseLevel() {
        return this.iDefinesCreditAtCourseLevel;
    }

    public void setDefinesCreditAtCourseLevel(Boolean definesCreditAtCourseLevel) {
        this.iDefinesCreditAtCourseLevel = definesCreditAtCourseLevel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinFormula(value="(select f.uniqueid from %SCHEMA%.crse_credit_format f where f.reference = credit_format)")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public CourseCreditFormat getCourseCreditFormat() {
        return this.iCourseCreditFormat;
    }

    public void setCourseCreditFormat(CourseCreditFormat courseCreditFormat) {
        this.iCourseCreditFormat = courseCreditFormat;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="credit_type", nullable=false)
    public CourseCreditType getCreditType() {
        return this.iCreditType;
    }

    public void setCreditType(CourseCreditType creditType) {
        this.iCreditType = creditType;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="credit_unit_type", nullable=false)
    public CourseCreditUnitType getCreditUnitType() {
        return this.iCreditUnitType;
    }

    public void setCreditUnitType(CourseCreditUnitType creditUnitType) {
        this.iCreditUnitType = creditUnitType;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="owner_id", nullable=true)
    public SchedulingSubpart getSubpartOwner() {
        return this.iSubpartOwner;
    }

    public void setSubpartOwner(SchedulingSubpart subpartOwner) {
        this.iSubpartOwner = subpartOwner;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_id", nullable=true)
    public CourseOffering getCourseOwner() {
        return this.iCourseOwner;
    }

    public void setCourseOwner(CourseOffering courseOwner) {
        this.iCourseOwner = courseOwner;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseCreditUnitConfig)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseCreditUnitConfig)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseCreditUnitConfig)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseCreditUnitConfig[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseCreditUnitConfig[\n\tCourseOwner: " + this.getCourseOwner() + "\n\tCreditType: " + this.getCreditType() + "\n\tCreditUnitType: " + this.getCreditUnitType() + "\n\tDefinesCreditAtCourseLevel: " + this.getDefinesCreditAtCourseLevel() + "\n\tSubpartOwner: " + this.getSubpartOwner() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

