/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.CourseCatalog;
import org.unitime.timetable.model.CourseSubpartCredit;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseCourseCatalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iSubject;
    private String iCourseNumber;
    private String iTitle;
    private String iPermanentId;
    private String iApprovalType;
    private String iPreviousSubject;
    private String iPreviousCourseNumber;
    private String iCreditType;
    private String iCreditUnitType;
    private String iCreditFormat;
    private Float iFixedMinimumCredit;
    private Float iMaximumCredit;
    private Boolean iFractionalCreditAllowed;
    private Session iSession;
    private Set<CourseSubpartCredit> iSubparts;

    public BaseCourseCatalog() {
    }

    public BaseCourseCatalog(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="subject", nullable=false, length=10)
    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    @Column(name="course_nbr", nullable=false, length=10)
    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public void setCourseNumber(String courseNumber) {
        this.iCourseNumber = courseNumber;
    }

    @Column(name="title", nullable=false, length=100)
    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    @Column(name="perm_id", nullable=true, length=20)
    public String getPermanentId() {
        return this.iPermanentId;
    }

    public void setPermanentId(String permanentId) {
        this.iPermanentId = permanentId;
    }

    @Column(name="approval_type", nullable=true, length=20)
    public String getApprovalType() {
        return this.iApprovalType;
    }

    public void setApprovalType(String approvalType) {
        this.iApprovalType = approvalType;
    }

    @Column(name="prev_subject", nullable=true, length=10)
    public String getPreviousSubject() {
        return this.iPreviousSubject;
    }

    public void setPreviousSubject(String previousSubject) {
        this.iPreviousSubject = previousSubject;
    }

    @Column(name="prev_crs_nbr", nullable=true, length=10)
    public String getPreviousCourseNumber() {
        return this.iPreviousCourseNumber;
    }

    public void setPreviousCourseNumber(String previousCourseNumber) {
        this.iPreviousCourseNumber = previousCourseNumber;
    }

    @Column(name="credit_type", nullable=false, length=20)
    public String getCreditType() {
        return this.iCreditType;
    }

    public void setCreditType(String creditType) {
        this.iCreditType = creditType;
    }

    @Column(name="credit_unit_type", nullable=false, length=20)
    public String getCreditUnitType() {
        return this.iCreditUnitType;
    }

    public void setCreditUnitType(String creditUnitType) {
        this.iCreditUnitType = creditUnitType;
    }

    @Column(name="credit_format", nullable=false, length=20)
    public String getCreditFormat() {
        return this.iCreditFormat;
    }

    public void setCreditFormat(String creditFormat) {
        this.iCreditFormat = creditFormat;
    }

    @Column(name="fixed_min_credit", nullable=false, length=10)
    public Float getFixedMinimumCredit() {
        return this.iFixedMinimumCredit;
    }

    public void setFixedMinimumCredit(Float fixedMinimumCredit) {
        this.iFixedMinimumCredit = fixedMinimumCredit;
    }

    @Column(name="max_credit", nullable=true, length=10)
    public Float getMaximumCredit() {
        return this.iMaximumCredit;
    }

    public void setMaximumCredit(Float maximumCredit) {
        this.iMaximumCredit = maximumCredit;
    }

    @Column(name="frac_credit_allowed", nullable=true, length=10)
    public Boolean isFractionalCreditAllowed() {
        return this.iFractionalCreditAllowed;
    }

    @Transient
    public Boolean getFractionalCreditAllowed() {
        return this.iFractionalCreditAllowed;
    }

    public void setFractionalCreditAllowed(Boolean fractionalCreditAllowed) {
        this.iFractionalCreditAllowed = fractionalCreditAllowed;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="course_catalog_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<CourseSubpartCredit> getSubparts() {
        return this.iSubparts;
    }

    public void setSubparts(Set<CourseSubpartCredit> subparts) {
        this.iSubparts = subparts;
    }

    public void addToSubparts(CourseSubpartCredit courseSubpartCredit) {
        if (this.iSubparts == null) {
            this.iSubparts = new HashSet<CourseSubpartCredit>();
        }
        this.iSubparts.add(courseSubpartCredit);
    }

    @Deprecated
    public void addTosubparts(CourseSubpartCredit courseSubpartCredit) {
        this.addToSubparts(courseSubpartCredit);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseCatalog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseCatalog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseCatalog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseCatalog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseCatalog[\n\tApprovalType: " + this.getApprovalType() + "\n\tCourseNumber: " + this.getCourseNumber() + "\n\tCreditFormat: " + this.getCreditFormat() + "\n\tCreditType: " + this.getCreditType() + "\n\tCreditUnitType: " + this.getCreditUnitType() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFixedMinimumCredit: " + this.getFixedMinimumCredit() + "\n\tFractionalCreditAllowed: " + this.getFractionalCreditAllowed() + "\n\tMaximumCredit: " + this.getMaximumCredit() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tPreviousCourseNumber: " + this.getPreviousCourseNumber() + "\n\tPreviousSubject: " + this.getPreviousSubject() + "\n\tSession: " + this.getSession() + "\n\tSubject: " + this.getSubject() + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

