/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.SolverInfo;

@MappedSuperclass
public abstract class BaseConstraintInfo
extends SolverInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<Assignment> iAssignments;

    public BaseConstraintInfo() {
    }

    public BaseConstraintInfo(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToMany
    @JoinTable(name="constraint_info", joinColumns={@JoinColumn(name="solver_info_id")}, inverseJoinColumns={@JoinColumn(name="assignment_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Assignment> getAssignments() {
        return this.iAssignments;
    }

    public void setAssignments(Set<Assignment> assignments) {
        this.iAssignments = assignments;
    }

    public void addToAssignments(Assignment assignment) {
        if (this.iAssignments == null) {
            this.iAssignments = new HashSet<Assignment>();
        }
        this.iAssignments.add(assignment);
    }

    @Deprecated
    public void addToassignments(Assignment assignment) {
        this.addToAssignments(assignment);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof ConstraintInfo)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ConstraintInfo)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ConstraintInfo)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "ConstraintInfo[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "ConstraintInfo[\n\tData: " + this.getData() + "\n\tDefinition: " + this.getDefinition() + "\n\tOpt: " + this.getOpt() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

