/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.timetable.model.ClusterDiscovery;
import org.unitime.timetable.model.base.ClusterDiscoveryId;

@MappedSuperclass
@IdClass(value=ClusterDiscoveryId.class)
public abstract class BaseClusterDiscovery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iOwnAddress;
    private String iClusterName;
    private byte[] iPingData;
    private Date iTimeStamp;

    @Id
    @Column(name="own_address", length=200)
    public String getOwnAddress() {
        return this.iOwnAddress;
    }

    public void setOwnAddress(String ownAddress) {
        this.iOwnAddress = ownAddress;
    }

    @Id
    @Column(name="cluster_name", length=200)
    public String getClusterName() {
        return this.iClusterName;
    }

    public void setClusterName(String clusterName) {
        this.iClusterName = clusterName;
    }

    @Column(name="ping_data", nullable=true, length=5000)
    public byte[] getPingData() {
        return this.iPingData;
    }

    public void setPingData(byte[] pingData) {
        this.iPingData = pingData;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ClusterDiscovery)) {
            return false;
        }
        ClusterDiscovery clusterDiscovery = (ClusterDiscovery)o;
        if (this.getOwnAddress() == null || clusterDiscovery.getOwnAddress() == null || !this.getOwnAddress().equals(clusterDiscovery.getOwnAddress())) {
            return false;
        }
        return this.getClusterName() != null && clusterDiscovery.getClusterName() != null && this.getClusterName().equals(clusterDiscovery.getClusterName());
    }

    public int hashCode() {
        if (this.getOwnAddress() == null || this.getClusterName() == null) {
            return super.hashCode();
        }
        return this.getOwnAddress().hashCode() ^ this.getClusterName().hashCode();
    }

    public String toString() {
        return "ClusterDiscovery[" + this.getOwnAddress() + ", " + this.getClusterName() + "]";
    }

    public String toDebugString() {
        return "ClusterDiscovery[\n\tClusterName: " + this.getClusterName() + "\n\tOwnAddress: " + this.getOwnAddress() + "\n\tPingData: " + this.getPingData() + "\n\tTimeStamp: " + this.getTimeStamp() + "]";
    }
}

