/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BaseChangeLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimeStamp;
    private String iObjectType;
    private String iObjectTitle;
    private Long iObjectUniqueId;
    private String iSourceString;
    private String iOperationString;
    private byte[] iDetail;
    private Session iSession;
    private TimetableManager iManager;
    private SubjectArea iSubjectArea;
    private Department iDepartment;

    public BaseChangeLog() {
    }

    public BaseChangeLog(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="obj_type", nullable=false, length=255)
    public String getObjectType() {
        return this.iObjectType;
    }

    public void setObjectType(String objectType) {
        this.iObjectType = objectType;
    }

    @Column(name="obj_title", nullable=false, length=255)
    public String getObjectTitle() {
        return this.iObjectTitle;
    }

    public void setObjectTitle(String objectTitle) {
        this.iObjectTitle = objectTitle;
    }

    @Column(name="obj_uid", nullable=false)
    public Long getObjectUniqueId() {
        return this.iObjectUniqueId;
    }

    public void setObjectUniqueId(Long objectUniqueId) {
        this.iObjectUniqueId = objectUniqueId;
    }

    @Column(name="source", nullable=false, length=50)
    public String getSourceString() {
        return this.iSourceString;
    }

    public void setSourceString(String sourceString) {
        this.iSourceString = sourceString;
    }

    @Column(name="operation", nullable=false, length=50)
    public String getOperationString() {
        return this.iOperationString;
    }

    public void setOperationString(String operationString) {
        this.iOperationString = operationString;
    }

    @Column(name="detail", nullable=true)
    public byte[] getDetail() {
        return this.iDetail;
    }

    public void setDetail(byte[] detail) {
        this.iDetail = detail;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="manager_id", nullable=false)
    public TimetableManager getManager() {
        return this.iManager;
    }

    public void setManager(TimetableManager manager) {
        this.iManager = manager;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="subj_area_id", nullable=true)
    public SubjectArea getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(SubjectArea subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="department_id", nullable=true)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ChangeLog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ChangeLog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ChangeLog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ChangeLog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ChangeLog[\n\tDepartment: " + this.getDepartment() + "\n\tDetail: " + this.getDetail() + "\n\tManager: " + this.getManager() + "\n\tObjectTitle: " + this.getObjectTitle() + "\n\tObjectType: " + this.getObjectType() + "\n\tObjectUniqueId: " + this.getObjectUniqueId() + "\n\tOperationString: " + this.getOperationString() + "\n\tSession: " + this.getSession() + "\n\tSourceString: " + this.getSourceString() + "\n\tSubjectArea: " + this.getSubjectArea() + "\n\tTimeStamp: " + this.getTimeStamp() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

