/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AdvisorCourseRequest;
import org.unitime.timetable.model.AdvisorSectioningPref;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.FreeTime;
import org.unitime.timetable.model.Student;

@MappedSuperclass
public abstract class BaseAdvisorCourseRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPriority;
    private Boolean iSubstitute;
    private Integer iAlternative;
    private Date iTimestamp;
    private String iChangedBy;
    private String iCredit;
    private String iCourse;
    private String iNotes;
    private Integer iCritical;
    private Boolean iWaitlist;
    private Boolean iNoSub;
    private Student iStudent;
    private CourseOffering iCourseOffering;
    private FreeTime iFreeTime;
    private Set<AdvisorSectioningPref> iPreferences;

    public BaseAdvisorCourseRequest() {
    }

    public BaseAdvisorCourseRequest(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="priority", nullable=false, length=10)
    public Integer getPriority() {
        return this.iPriority;
    }

    public void setPriority(Integer priority) {
        this.iPriority = priority;
    }

    @Column(name="substitute", nullable=false)
    public Boolean isSubstitute() {
        return this.iSubstitute;
    }

    @Transient
    public Boolean getSubstitute() {
        return this.iSubstitute;
    }

    public void setSubstitute(Boolean substitute) {
        this.iSubstitute = substitute;
    }

    @Column(name="alternative", nullable=false, length=10)
    public Integer getAlternative() {
        return this.iAlternative;
    }

    public void setAlternative(Integer alternative) {
        this.iAlternative = alternative;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimestamp() {
        return this.iTimestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.iTimestamp = timestamp;
    }

    @Column(name="changed_by", nullable=true, length=40)
    public String getChangedBy() {
        return this.iChangedBy;
    }

    public void setChangedBy(String changedBy) {
        this.iChangedBy = changedBy;
    }

    @Column(name="credit", nullable=true, length=10)
    public String getCredit() {
        return this.iCredit;
    }

    public void setCredit(String credit) {
        this.iCredit = credit;
    }

    @Column(name="course", nullable=true, length=1024)
    public String getCourse() {
        return this.iCourse;
    }

    public void setCourse(String course) {
        this.iCourse = course;
    }

    @Column(name="notes", nullable=true, length=2048)
    public String getNotes() {
        return this.iNotes;
    }

    public void setNotes(String notes) {
        this.iNotes = notes;
    }

    @Column(name="critical", nullable=true)
    public Integer getCritical() {
        return this.iCritical;
    }

    public void setCritical(Integer critical) {
        this.iCritical = critical;
    }

    @Column(name="waitlist", nullable=true)
    public Boolean isWaitlist() {
        return this.iWaitlist;
    }

    @Transient
    public Boolean getWaitlist() {
        return this.iWaitlist;
    }

    public void setWaitlist(Boolean waitlist) {
        this.iWaitlist = waitlist;
    }

    @Column(name="nosub", nullable=true)
    public Boolean isNoSub() {
        return this.iNoSub;
    }

    @Transient
    public Boolean getNoSub() {
        return this.iNoSub;
    }

    public void setNoSub(Boolean noSub) {
        this.iNoSub = noSub;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="student_id", nullable=false)
    public Student getStudent() {
        return this.iStudent;
    }

    public void setStudent(Student student) {
        this.iStudent = student;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="course_offering_id", nullable=true)
    public CourseOffering getCourseOffering() {
        return this.iCourseOffering;
    }

    public void setCourseOffering(CourseOffering courseOffering) {
        this.iCourseOffering = courseOffering;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="free_time_id", nullable=true)
    public FreeTime getFreeTime() {
        return this.iFreeTime;
    }

    public void setFreeTime(FreeTime freeTime) {
        this.iFreeTime = freeTime;
    }

    @OneToMany(mappedBy="courseRequest", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<AdvisorSectioningPref> getPreferences() {
        return this.iPreferences;
    }

    public void setPreferences(Set<AdvisorSectioningPref> preferences) {
        this.iPreferences = preferences;
    }

    public void addToPreferences(AdvisorSectioningPref advisorSectioningPref) {
        if (this.iPreferences == null) {
            this.iPreferences = new HashSet<AdvisorSectioningPref>();
        }
        this.iPreferences.add(advisorSectioningPref);
    }

    @Deprecated
    public void addTopreferences(AdvisorSectioningPref advisorSectioningPref) {
        this.addToPreferences(advisorSectioningPref);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AdvisorCourseRequest)) {
            return false;
        }
        if (this.getUniqueId() == null || ((AdvisorCourseRequest)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((AdvisorCourseRequest)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "AdvisorCourseRequest[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "AdvisorCourseRequest[\n\tAlternative: " + this.getAlternative() + "\n\tChangedBy: " + this.getChangedBy() + "\n\tCourse: " + this.getCourse() + "\n\tCourseOffering: " + this.getCourseOffering() + "\n\tCredit: " + this.getCredit() + "\n\tCritical: " + this.getCritical() + "\n\tFreeTime: " + this.getFreeTime() + "\n\tNoSub: " + this.getNoSub() + "\n\tNotes: " + this.getNotes() + "\n\tPriority: " + this.getPriority() + "\n\tStudent: " + this.getStudent() + "\n\tSubstitute: " + this.getSubstitute() + "\n\tTimestamp: " + this.getTimestamp() + "\n\tUniqueId: " + this.getUniqueId() + "\n\tWaitlist: " + this.getWaitlist() + "]";
    }
}

