/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseAcademicClassification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iCode;
    private String iName;
    private Session iSession;

    public BaseAcademicClassification() {
    }

    public BaseAcademicClassification(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="acad_class_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="code", nullable=false, length=10)
    public String getCode() {
        return this.iCode;
    }

    public void setCode(String code) {
        this.iCode = code;
    }

    @Column(name="name", nullable=false, length=100)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AcademicClassification)) {
            return false;
        }
        if (this.getUniqueId() == null || ((AcademicClassification)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((AcademicClassification)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "AcademicClassification[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "AcademicClassification[\n\tCode: " + this.getCode() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tName: " + this.getName() + "\n\tSession: " + this.getSession() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

