/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseAcademicArea
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iAcademicAreaAbbreviation;
    private String iTitle;
    private Session iSession;
    private Set<PosMajor> iPosMajors;
    private Set<PosMinor> iPosMinors;

    public BaseAcademicArea() {
    }

    public BaseAcademicArea(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="academic_area_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="academic_area_abbreviation", nullable=false, length=40)
    public String getAcademicAreaAbbreviation() {
        return this.iAcademicAreaAbbreviation;
    }

    public void setAcademicAreaAbbreviation(String academicAreaAbbreviation) {
        this.iAcademicAreaAbbreviation = academicAreaAbbreviation;
    }

    @Column(name="long_title", nullable=false, length=100)
    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="academicAreas")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMajor> getPosMajors() {
        return this.iPosMajors;
    }

    public void setPosMajors(Set<PosMajor> posMajors) {
        this.iPosMajors = posMajors;
    }

    public void addToPosMajors(PosMajor posMajor) {
        if (this.iPosMajors == null) {
            this.iPosMajors = new HashSet<PosMajor>();
        }
        this.iPosMajors.add(posMajor);
    }

    @Deprecated
    public void addToposMajors(PosMajor posMajor) {
        this.addToPosMajors(posMajor);
    }

    @ManyToMany(fetch=FetchType.LAZY, mappedBy="academicAreas")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PosMinor> getPosMinors() {
        return this.iPosMinors;
    }

    public void setPosMinors(Set<PosMinor> posMinors) {
        this.iPosMinors = posMinors;
    }

    public void addToPosMinors(PosMinor posMinor) {
        if (this.iPosMinors == null) {
            this.iPosMinors = new HashSet<PosMinor>();
        }
        this.iPosMinors.add(posMinor);
    }

    @Deprecated
    public void addToposMinors(PosMinor posMinor) {
        this.addToPosMinors(posMinor);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AcademicArea)) {
            return false;
        }
        if (this.getUniqueId() == null || ((AcademicArea)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((AcademicArea)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "AcademicArea[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "AcademicArea[\n\tAcademicAreaAbbreviation: " + this.getAcademicAreaAbbreviation() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tSession: " + this.getSession() + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

