/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Iterator;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseStudentClassEnrollment;
import org.unitime.timetable.model.dao.StudentClassEnrollmentDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="student_class_enrl")
public class StudentClassEnrollment
extends BaseStudentClassEnrollment {
    private static final long serialVersionUID = 1L;

    public StudentClassEnrollment() {
    }

    public StudentClassEnrollment(Long uniqueId) {
        super(uniqueId);
    }

    public static List<StudentClassEnrollment> findAll(Long sessionId) {
        return StudentClassEnrollmentDAO.getInstance().getSession().createQuery("select e from StudentClassEnrollment e where e.student.session.uniqueId=:sessionId", StudentClassEnrollment.class).setParameter("sessionId", (Object)sessionId).list();
    }

    public static Iterator<StudentClassEnrollment> findAllForStudent(Long studentId) {
        return StudentClassEnrollmentDAO.getInstance().getSession().createQuery("select e from StudentClassEnrollment e where e.student.uniqueId=:studentId", StudentClassEnrollment.class).setParameter("studentId", (Object)studentId).setCacheable(true).list().iterator();
    }

    public static boolean sessionHasEnrollments(Long sessionId) {
        if (sessionId != null) {
            return ((Number)StudentClassEnrollmentDAO.getInstance().getSession().createQuery("select count(e) from StudentClassEnrollment e where e.student.session.uniqueId=:sessionId", Number.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).uniqueResult()).longValue() > 0L;
        }
        return false;
    }

    public static enum SystemChange {
        WAITLIST("System: Wait-List"),
        SYSTEM("System: Course Change"),
        IMPORT("Data Exchange"),
        BATCH("Batch Sectioning"),
        TEST("Test");

        private String iName;

        private SystemChange(String name) {
            this.iName = name;
        }

        @Transient
        public String getName() {
            return this.iName;
        }
    }
}

