/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.base.BaseSolverGroup;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="solver_group")
public class SolverGroup
extends BaseSolverGroup
implements Comparable,
Qualifiable {
    private static final long serialVersionUID = 1L;

    public SolverGroup() {
    }

    public SolverGroup(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public boolean isExternalManager() {
        for (Department d : this.getDepartments()) {
            if (!d.isExternalManager().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Transient
    public Collection getClasses() {
        Vector<Class_> classes = new Vector<Class_>();
        for (Department d : this.getDepartments()) {
            classes.addAll(d.getClasses());
        }
        return classes;
    }

    public Collection getNotAssignedClasses(Solution solution) {
        Vector<Class_> classes = new Vector<Class_>();
        for (Department d : this.getDepartments()) {
            classes.addAll(d.getNotAssignedClasses(solution));
        }
        return classes;
    }

    @Transient
    public Set getDistributionPreferences() {
        TreeSet prefs = new TreeSet();
        for (Department d : this.getDepartments()) {
            prefs.addAll(d.getDistributionPreferences());
        }
        return prefs;
    }

    public static Set<SolverGroup> findBySessionId(Long sessionId) {
        return new TreeSet<SolverGroup>(SolverGroupDAO.getInstance().getSession().createQuery("select sg from SolverGroup sg where sg.session.uniqueId=:sessionId", SolverGroup.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list());
    }

    public static SolverGroup findBySessionIdName(Long sessionId, String name) {
        List groups = SolverGroupDAO.getInstance().getSession().createQuery("select sg from SolverGroup sg where sg.session.uniqueId=:sessionId and sg.name=:name", SolverGroup.class).setParameter("sessionId", (Object)sessionId).setParameter("name", (Object)name).setCacheable(true).list();
        if (groups.isEmpty()) {
            return null;
        }
        return (SolverGroup)groups.get(0);
    }

    public static SolverGroup findBySessionIdAbbv(Long sessionId, String abbv) {
        List groups = SolverGroupDAO.getInstance().getSession().createQuery("select sg from SolverGroup sg where sg.session.uniqueId=:sessionId and sg.abbv=:abbv", SolverGroup.class).setParameter("sessionId", (Object)sessionId).setParameter("abbv", (Object)abbv).setCacheable(true).list();
        if (groups.isEmpty()) {
            return null;
        }
        return (SolverGroup)groups.get(0);
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof SolverGroup)) {
            return -1;
        }
        SolverGroup sg = (SolverGroup)o;
        int cmp = this.getName().compareTo(sg.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(sg.getUniqueId() == null ? -1L : sg.getUniqueId());
    }

    @Transient
    public Solution getCommittedSolution() {
        if (this.getSolutions() == null) {
            return null;
        }
        for (Solution s : this.getSolutions()) {
            if (!s.isCommited().booleanValue()) continue;
            return s;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Transient
    public int getMinDistributionPriority() {
        int ret = Integer.MAX_VALUE;
        for (Department d : this.getDepartments()) {
            ret = Math.min(ret, d.getDistributionPrefPriority());
        }
        return ret;
    }

    @Transient
    public int getMaxDistributionPriority() {
        int ret = Integer.MIN_VALUE;
        for (Department d : this.getDepartments()) {
            ret = Math.max(ret, d.getDistributionPrefPriority());
        }
        return ret;
    }

    public Object clone() {
        SolverGroup sg = new SolverGroup();
        sg.setSession(this.getSession());
        sg.setAbbv(this.getAbbv());
        sg.setName(this.getName());
        return sg;
    }

    @Override
    @Transient
    public Serializable getQualifierId() {
        return this.getUniqueId();
    }

    @Override
    @Transient
    public String getQualifierType() {
        return this.getClass().getSimpleName();
    }

    @Override
    @Transient
    public String getQualifierReference() {
        return this.getAbbv();
    }

    @Override
    @Transient
    public String getQualifierLabel() {
        return this.getName();
    }

    public static TreeSet<SolverGroup> getUserSolverGroups(UserContext user) {
        TreeSet<SolverGroup> solverGroups = new TreeSet<SolverGroup>();
        if (user == null || user.getCurrentAuthority() == null) {
            return solverGroups;
        }
        if (user.getCurrentAuthority().hasRight(Right.DepartmentIndependent)) {
            solverGroups.addAll(SolverGroup.findBySessionId(user.getCurrentAcademicSessionId()));
        } else {
            for (UserQualifier userQualifier : user.getCurrentAuthority().getQualifiers("SolverGroup")) {
                solverGroups.add((SolverGroup)SolverGroupDAO.getInstance().get((Long)userQualifier.getQualifierId()));
            }
        }
        return solverGroups;
    }

    @Transient
    public boolean isAllowStudentScheduling() {
        for (Department department : this.getDepartments()) {
            if (!department.isAllowStudentScheduling().booleanValue()) continue;
            return true;
        }
        return false;
    }
}

