/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.cpsolver.ifs.util.ToolBox;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.base.BaseRoomFeaturePref;

@Entity
@Table(name="room_feature_pref")
public class RoomFeaturePref
extends BaseRoomFeaturePref {
    private static final long serialVersionUID = 1L;

    public RoomFeaturePref() {
    }

    public RoomFeaturePref(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String preferenceText() {
        Object ret = this.getRoomFeature().getLabel();
        if (this.getRoomIndex() != null) {
            ret = (String)ret + " (" + MSG.itemOnlyRoom(1 + this.getRoomIndex()) + ")";
        }
        return ret;
    }

    @Override
    public String preferenceAbbv() {
        Object ret = this.getRoomFeature().getAbbv();
        if (this.getRoomIndex() != null) {
            ret = (String)ret + " (" + MSG.itemOnlyRoom(1 + this.getRoomIndex()) + ")";
        }
        return ret;
    }

    @Override
    public int compareTo(Object o) {
        try {
            RoomFeaturePref p = (RoomFeaturePref)o;
            int cmp = Integer.compare(this.getRoomIndex() == null ? -1 : this.getRoomIndex(), p.getRoomIndex() == null ? -1 : p.getRoomIndex());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getRoomFeature().getLabel().compareTo(p.getRoomFeature().getLabel());
            if (cmp != 0) {
                return cmp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareTo(o);
    }

    @Override
    public Object clone() {
        RoomFeaturePref pref = new RoomFeaturePref();
        pref.setPrefLevel(this.getPrefLevel());
        pref.setRoomFeature(this.getRoomFeature());
        pref.setRoomIndex(this.getRoomIndex());
        return pref;
    }

    @Override
    public boolean isSame(Preference other) {
        if (other == null || !(other instanceof RoomFeaturePref)) {
            return false;
        }
        return ToolBox.equals((Object)this.getRoomFeature(), (Object)((RoomFeaturePref)other).getRoomFeature()) && ToolBox.equals((Object)this.getRoomIndex(), (Object)((RoomFeaturePref)other).getRoomIndex());
    }

    @Override
    public boolean isSame(Preference other, PreferenceGroup level) {
        if (other == null || !(other instanceof RoomFeaturePref)) {
            return false;
        }
        if (!ToolBox.equals((Object)this.getRoomFeature(), (Object)((RoomFeaturePref)other).getRoomFeature())) {
            return false;
        }
        if (!(level == null || !(level instanceof Class_) || ((Class_)level).getNbrRooms() != 1 || this.getRoomIndex() != null && this.getRoomIndex() != 0 || ((RoomFeaturePref)other).getRoomIndex() != null && ((RoomFeaturePref)other).getRoomIndex() != 0)) {
            return true;
        }
        return ToolBox.equals((Object)this.getRoomIndex(), (Object)((RoomFeaturePref)other).getRoomIndex());
    }

    public boolean isApplicable(PreferenceGroup group) {
        return true;
    }

    @Override
    public String preferenceTitle() {
        return MSG.prefTitleRoomFeature(this.getPrefLevel().getPrefName(), this.getRoomFeature().getLabelWithType());
    }

    @Override
    @Transient
    public Preference.Type getType() {
        return Preference.Type.ROOM_FEATURE;
    }

    @Override
    public String preferenceDescription() {
        return this.getRoomFeature().getDescription();
    }

    @Override
    public boolean appliesTo(PreferenceGroup group) {
        if (!super.appliesTo(group)) {
            return false;
        }
        if (this.getRoomIndex() != null && group instanceof Class_) {
            return this.getRoomIndex() < ((Class_)group).getNbrRooms();
        }
        if (this.getRoomIndex() != null && group instanceof SchedulingSubpart) {
            return this.getRoomIndex() < ((SchedulingSubpart)group).getMaxRooms();
        }
        return true;
    }
}

