/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.base.BaseRelatedCourseInfo;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.ExamOwnerDAO;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao.RelatedCourseInfoDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="related_course_info")
public class RelatedCourseInfo
extends BaseRelatedCourseInfo
implements Comparable<RelatedCourseInfo> {
    private static final long serialVersionUID = 1L;
    private Object iOwnerObject = null;

    public RelatedCourseInfo() {
    }

    public RelatedCourseInfo(Long uniqueId) {
        super(uniqueId);
    }

    public static List<RelatedCourseInfo> findByOwnerIdType(Session hibSession, Long ownerId, Integer ownerType) {
        return hibSession.createQuery("select o from RelatedCourseInfo o where o.ownerId=:ownerId and o.ownerType=:ownerType", RelatedCourseInfo.class).setParameter("ownerId", (Object)ownerId).setParameter("ownerType", (Object)ownerType).setCacheable(true).list();
    }

    public static List findByOwnerIdType(Long ownerId, Integer ownerType) {
        return RelatedCourseInfo.findByOwnerIdType(RelatedCourseInfoDAO.getInstance().getSession(), ownerId, ownerType);
    }

    @Transient
    public Object getOwnerObject() {
        if (this.iOwnerObject != null) {
            return this.iOwnerObject;
        }
        switch (this.getOwnerType()) {
            case 3: {
                this.iOwnerObject = new Class_DAO().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 2: {
                this.iOwnerObject = InstrOfferingConfigDAO.getInstance().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 1: {
                this.iOwnerObject = CourseOfferingDAO.getInstance().get(this.getOwnerId());
                return this.iOwnerObject;
            }
            case 0: {
                this.iOwnerObject = InstructionalOfferingDAO.getInstance().get(this.getOwnerId());
                return this.iOwnerObject;
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public void setOwner(Class_ clazz) {
        this.setOwnerId(clazz.getUniqueId());
        this.setOwnerType(3);
        this.setCourse(clazz.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering());
    }

    public void setOwner(InstrOfferingConfig config) {
        this.setOwnerId(config.getUniqueId());
        this.setOwnerType(2);
        this.setCourse(config.getControllingCourseOffering());
    }

    public void setOwner(CourseOffering course) {
        this.setOwnerId(course.getUniqueId());
        this.setOwnerType(1);
        this.setCourse(course);
    }

    public void setOwner(InstructionalOffering offering) {
        this.setOwnerId(offering.getUniqueId());
        this.setOwnerType(0);
        this.setCourse(offering.getControllingCourseOffering());
    }

    public CourseOffering computeCourse() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getSchedulingSubpart().getControllingCourseOffering();
            }
            case 2: {
                return ((InstrOfferingConfig)owner).getControllingCourseOffering();
            }
            case 1: {
                return (CourseOffering)owner;
            }
            case 0: {
                return ((InstructionalOffering)owner).getControllingCourseOffering();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Override
    public int compareTo(RelatedCourseInfo owner) {
        CourseOffering c1 = this.getCourse();
        CourseOffering c2 = owner.getCourse();
        int cmp = 0;
        cmp = c1.getSubjectAreaAbbv().compareTo(c2.getSubjectAreaAbbv());
        if (cmp != 0) {
            return cmp;
        }
        cmp = c1.getCourseNbr().compareTo(c2.getCourseNbr());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getOwnerType().compareTo(owner.getOwnerType());
        if (cmp != 0) {
            return cmp;
        }
        switch (this.getOwnerType()) {
            case 3: {
                return new ClassComparator(5).compare((Class_)this.getOwnerObject(), (Class_)owner.getOwnerObject());
            }
            case 2: {
                return new InstrOfferingConfigComparator(null).compare(this.getOwnerObject(), owner.getOwnerObject());
            }
        }
        return this.getOwnerId().compareTo(owner.getOwnerId());
    }

    @Transient
    public List<Student> getStudents() {
        switch (this.getOwnerType()) {
            case 3: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :eventOwnerId", Student.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 2: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId", Student.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 1: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :eventOwnerId", Student.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 0: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :eventOwnerId", Student.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Transient
    public List<StudentClassEnrollment> getStudentClassEnrollments() {
        switch (this.getOwnerType()) {
            case 3: {
                return ExamOwnerDAO.getInstance().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.uniqueId = :classId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student", StudentClassEnrollment.class).setParameter("classId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 2: {
                return ExamOwnerDAO.getInstance().getSession().createQuery("select distinct e from StudentClassEnrollment e, StudentClassEnrollment f where f.clazz.schedulingSubpart.instrOfferingConfig.uniqueId = :configId and e.courseOffering.instructionalOffering = f.courseOffering.instructionalOffering and e.student = f.student", StudentClassEnrollment.class).setParameter("configId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 1: {
                return ExamOwnerDAO.getInstance().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.uniqueId = :courseId", StudentClassEnrollment.class).setParameter("courseId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 0: {
                return ExamOwnerDAO.getInstance().getSession().createQuery("select e from StudentClassEnrollment e where e.courseOffering.instructionalOffering.uniqueId = :offeringId", StudentClassEnrollment.class).setParameter("offeringId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Transient
    public List<Long> getStudentIds() {
        switch (this.getOwnerType()) {
            case 3: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :eventOwnerId", Long.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 2: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId", Long.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 1: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :eventOwnerId", Long.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 0: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct e.student.uniqueId from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :eventOwnerId", Long.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Transient
    public List<DepartmentalInstructor> getInstructors() {
        switch (this.getOwnerType()) {
            case 3: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select i from Class_ c inner join c.classInstructors ci inner join ci.instructor i where c.uniqueId = :eventOwnerId and ci.lead=true", DepartmentalInstructor.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 2: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct i from Class_ c inner join c.classInstructors ci inner join ci.instructor i where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId", DepartmentalInstructor.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 1: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct i from Class_ c inner join c.classInstructors ci inner join ci.instructor i inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :eventOwnerId", DepartmentalInstructor.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
            case 0: {
                return RelatedCourseInfoDAO.getInstance().getSession().createQuery("select distinct i from Class_ c inner join c.classInstructors ci inner join ci.instructor i where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.uniqueId = :eventOwnerId", DepartmentalInstructor.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).list();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    public int countStudents() {
        switch (this.getOwnerType()) {
            case 3: {
                return ((Number)RelatedCourseInfoDAO.getInstance().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.uniqueId = :eventOwnerId", Number.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).uniqueResult()).intValue();
            }
            case 2: {
                return ((Number)RelatedCourseInfoDAO.getInstance().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.clazz c  where c.schedulingSubpart.instrOfferingConfig.uniqueId = :eventOwnerId", Number.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).uniqueResult()).intValue();
            }
            case 1: {
                return ((Number)RelatedCourseInfoDAO.getInstance().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.uniqueId = :eventOwnerId", Number.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).uniqueResult()).intValue();
            }
            case 0: {
                return ((Number)RelatedCourseInfoDAO.getInstance().getSession().createQuery("select count(distinct e.student) from StudentClassEnrollment e inner join e.courseOffering co  where co.instructionalOffering.uniqueId = :eventOwnerId", Number.class).setParameter("eventOwnerId", (Object)this.getOwnerId()).setCacheable(true).uniqueResult()).intValue();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Transient
    public int getLimit() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getClassLimit();
            }
            case 2: {
                return ((InstrOfferingConfig)owner).getLimit();
            }
            case 1: {
                CourseOffering course = (CourseOffering)owner;
                if (course.getReservation() != null) {
                    return course.getReservation();
                }
                return course.getInstructionalOffering().getLimit() == null ? 0 : course.getInstructionalOffering().getLimit();
            }
            case 0: {
                return ((InstructionalOffering)owner).getLimit() == null ? 0 : ((InstructionalOffering)owner).getLimit();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }

    @Transient
    public String getLabel() {
        Object owner = this.getOwnerObject();
        switch (this.getOwnerType()) {
            case 3: {
                return ((Class_)owner).getClassLabel(this.getCourse());
            }
            case 2: {
                return this.getCourse().getCourseName() + " [" + ((InstrOfferingConfig)owner).getName() + "]";
            }
            case 1: {
                return ((CourseOffering)owner).getCourseName();
            }
            case 0: {
                return ((InstructionalOffering)owner).getCourseName();
            }
        }
        throw new RuntimeException("Unknown owner type " + this.getOwnerType());
    }
}

