/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseManagerSettings;
import org.unitime.timetable.model.dao.ManagerSettingsDAO;
import org.unitime.timetable.model.dao.SettingsDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="manager_settings")
public class ManagerSettings
extends BaseManagerSettings {
    private static final long serialVersionUID = 1L;

    public ManagerSettings() {
    }

    public ManagerSettings(Long uniqueId) {
        super(uniqueId);
    }

    public static String getValue(TimetableManager mgr, String name, String defaultValue) {
        if (mgr == null) {
            Settings s = (Settings)SettingsDAO.getInstance().getSession().createQuery("select s from Settings s where s.key = :key", Settings.class).setParameter("key", (Object)name).setCacheable(true).uniqueResult();
            return s == null ? defaultValue : s.getDefaultValue();
        }
        return ManagerSettings.getValue(mgr.getUniqueId(), name, defaultValue);
    }

    public static String getValue(TimetableManager mgr, String name) {
        return ManagerSettings.getValue(mgr, name, null);
    }

    public static String getValue(Long managerId, String name, String defaultValue) {
        if (managerId == null) {
            return defaultValue;
        }
        Settings s = (Settings)SettingsDAO.getInstance().getSession().createQuery("select s from Settings s where s.key = :key", Settings.class).setParameter("key", (Object)name).setCacheable(true).uniqueResult();
        if (s == null) {
            return defaultValue;
        }
        ManagerSettings m = (ManagerSettings)ManagerSettingsDAO.getInstance().getSession().createQuery("select m from ManagerSettings m where m.manager.uniqueId = :managerId and m.key.uniqueId = :settingsId", ManagerSettings.class).setParameter("managerId", (Object)managerId).setParameter("settingsId", (Object)s.getUniqueId()).setCacheable(true).uniqueResult();
        return m == null ? s.getDefaultValue() : m.getValue();
    }

    public static String getValue(Long managerId, String name) {
        return ManagerSettings.getValue(managerId, name, null);
    }
}

