/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseInstructorAttribute;
import org.unitime.timetable.model.dao.InstructorAttributeDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="attribute")
public class InstructorAttribute
extends BaseInstructorAttribute
implements Comparable<InstructorAttribute> {
    private static final long serialVersionUID = 331064011983395675L;
    public static String ATTRIBUTES_LIST_ATTR_NAME = "attributesList";

    @Override
    public int compareTo(InstructorAttribute s) {
        int cmp = (this.getType() == null ? "" : this.getType().getLabel()).compareTo(s.getType() == null ? "" : s.getType().getLabel());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getName().compareTo(s.getName());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(s.getUniqueId() == null ? -1L : s.getUniqueId());
    }

    public static List<InstructorAttribute> getAllGlobalAttributes(Long sessionId) throws HibernateException {
        return InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.session.uniqueId = :sessionId and ia.department is null order by name", InstructorAttribute.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static List<InstructorAttribute> getAllDepartmentalAttributes(Long departmentId) throws HibernateException {
        return InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.department.uniqueId = :departmentId order by name", InstructorAttribute.class).setParameter("departmentId", (Object)departmentId).setCacheable(true).list();
    }

    public InstructorAttribute findSameAttributeInSession(Session session) {
        if (session == null) {
            return null;
        }
        if (this.getDepartment() != null) {
            Department d = this.getDepartment().findSameDepartmentInSession(session);
            if (d == null) {
                return null;
            }
            return (InstructorAttribute)InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.department.uniqueId = :departmentId and ia.code = :code", InstructorAttribute.class).setParameter("departmentId", (Object)d.getUniqueId()).setParameter("code", (Object)this.getCode()).setCacheable(true).setMaxResults(1).uniqueResult();
        }
        return (InstructorAttribute)InstructorAttributeDAO.getInstance().getSession().createQuery("from InstructorAttribute ia where ia.session.uniqueId = :sessionId and ia.department is null and ia.code = :code", InstructorAttribute.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameter("code", (Object)this.getCode()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public boolean isParentOf(InstructorAttribute attribute) {
        while (attribute != null) {
            if (this.equals(attribute.getParentAttribute())) {
                return true;
            }
            attribute = attribute.getParentAttribute();
        }
        return false;
    }

    @Transient
    public String getNameWithType() {
        return this.getName() + (String)(this.getType() == null ? "" : " (" + this.getType().getLabel() + ")");
    }
}

