/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.Transient;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.CourseRequest;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAreaClassificationMajor;
import org.unitime.timetable.model.StudentAreaClassificationMinor;
import org.unitime.timetable.model.base.BaseCurriculumReservation;

@Entity
@DiscriminatorValue(value="2")
public class CurriculumReservation
extends BaseCurriculumReservation {
    private static final long serialVersionUID = -261396109078027984L;

    @Override
    public boolean isApplicable(Student student, CourseRequest request) {
        if (!this.getMajors().isEmpty() || this.getMinors().isEmpty()) {
            for (StudentAreaClassificationMajor studentAreaClassificationMajor : student.getAreaClasfMajors()) {
                if (!this.getAreas().contains(studentAreaClassificationMajor.getAcademicArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(studentAreaClassificationMajor.getAcademicClassification()) || !this.getMajors().isEmpty() && !this.getMajors().contains(studentAreaClassificationMajor.getMajor())) continue;
                return true;
            }
        }
        if (!this.getMinors().isEmpty()) {
            for (StudentAreaClassificationMinor studentAreaClassificationMinor : student.getAreaClasfMinors()) {
                if (!this.getAreas().contains(studentAreaClassificationMinor.getAcademicArea()) || !this.getClassifications().isEmpty() && !this.getClassifications().contains(studentAreaClassificationMinor.getAcademicClassification()) || !this.getMinors().contains(studentAreaClassificationMinor.getMinor())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Transient
    public int getPriority() {
        return ApplicationProperty.ReservationPriorityCurriculum.intValue();
    }

    @Override
    @Transient
    public boolean isCanAssignOverLimit() {
        return ApplicationProperty.ReservationCanOverLimitCurriculum.isTrue();
    }

    @Override
    @Transient
    public boolean isMustBeUsed() {
        return ApplicationProperty.ReservationMustBeUsedCurriculum.isTrue();
    }

    @Override
    @Transient
    public boolean isAllowOverlap() {
        return ApplicationProperty.ReservationAllowOverlapCurriculum.isTrue();
    }

    public boolean hasArea(String areaAbbv) {
        if (this.getAreas() == null || this.getAreas().isEmpty()) {
            return false;
        }
        for (AcademicArea area : this.getAreas()) {
            if (!area.getAcademicAreaAbbreviation().equals(areaAbbv)) continue;
            return true;
        }
        return false;
    }

    public boolean hasClassification(String classificationCode) {
        if (this.getClassifications().isEmpty()) {
            return true;
        }
        for (AcademicClassification c : this.getClassifications()) {
            if (!c.getCode().equals(classificationCode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMajor(String majorCode) {
        if (this.getMajors().isEmpty() && this.getMinors().isEmpty()) {
            return true;
        }
        for (PosMajor c : this.getMajors()) {
            if (!c.getCode().equals(majorCode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasConcentration(String majorCode, String concCode) {
        if (concCode == null) {
            return true;
        }
        boolean hasMajor = false;
        for (PosMajorConcentration c : this.getConcentrations()) {
            if (!c.getMajor().getCode().equals(majorCode)) continue;
            hasMajor = true;
            if (!c.getCode().equals(concCode)) continue;
            return true;
        }
        return !hasMajor;
    }

    public boolean hasMinor(String minorCode) {
        for (PosMinor c : this.getMinors()) {
            if (!c.getCode().equals(minorCode)) continue;
            return true;
        }
        return false;
    }
}

