/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.unitime.timetable.model.base.BaseCourseCreditType;
import org.unitime.timetable.model.dao.CourseCreditTypeDAO;
import org.unitime.timetable.model.dao.CourseCreditUnitTypeDAO;

@Entity
@Table(name="course_credit_type")
public class CourseCreditType
extends BaseCourseCreditType {
    private static final long serialVersionUID = 1L;
    public static String COURSE_CREDIT_TYPE_ATTR_NAME = "courseCreditTypeList";

    public CourseCreditType() {
    }

    public CourseCreditType(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public static List<CourseCreditType> getCourseCreditTypeList() {
        return CourseCreditTypeDAO.getInstance().getSession().createQuery("from CourseCreditType order by label", CourseCreditType.class).setCacheable(true).list();
    }

    public static CourseCreditType getCourseCreditTypeForReference(String referenceString) {
        if (referenceString == null || referenceString.isEmpty()) {
            return null;
        }
        return (CourseCreditType)CourseCreditUnitTypeDAO.getInstance().getSession().createQuery("from CourseCreditType where reference = :reference", CourseCreditType.class).setParameter("reference", (Object)referenceString).setMaxResults(1).setCacheable(true).uniqueResult();
    }

    public static CourseCreditType getCourseCreditTypeForUniqueId(Long uniqueId) {
        return uniqueId == null ? null : (CourseCreditType)CourseCreditTypeDAO.getInstance().get(uniqueId);
    }

    @Transient
    public String getAbbv() {
        if (this.getAbbreviation() == null) {
            return "";
        }
        return this.getAbbreviation();
    }
}

